/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;

public class EnumDefinition {
    private DescriptorProtos.EnumDescriptorProto mEnumType;

    public static Builder newBuilder(String enumName) {
        return EnumDefinition.newBuilder(enumName, null);
    }

    public static Builder newBuilder(String enumName, Boolean allowAlias) {
        return new Builder(enumName, allowAlias);
    }

    public String toString() {
        return this.mEnumType.toString();
    }

    DescriptorProtos.EnumDescriptorProto getEnumType() {
        return this.mEnumType;
    }

    private EnumDefinition(DescriptorProtos.EnumDescriptorProto enumType) {
        this.mEnumType = enumType;
    }

    public static class Builder {
        private DescriptorProtos.EnumDescriptorProto.Builder mEnumTypeBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();

        public String getName() {
            return this.mEnumTypeBuilder.getName();
        }

        public Builder addValue(String name, int num) {
            DescriptorProtos.EnumValueDescriptorProto.Builder enumValBuilder = DescriptorProtos.EnumValueDescriptorProto.newBuilder();
            enumValBuilder.setName(name).setNumber(num);
            this.mEnumTypeBuilder.addValue(enumValBuilder.build());
            return this;
        }

        public EnumDefinition build() {
            return new EnumDefinition(this.mEnumTypeBuilder.build());
        }

        private Builder(String enumName, Boolean allowAlias) {
            this.mEnumTypeBuilder.setName(enumName);
            if (allowAlias != null) {
                DescriptorProtos.EnumOptions.Builder optionsBuilder = DescriptorProtos.EnumOptions.newBuilder();
                optionsBuilder.setAllowAlias(allowAlias.booleanValue());
                this.mEnumTypeBuilder.mergeOptions(optionsBuilder.build());
            }
        }
    }
}

