/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.EnumSchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.diff.MessageSchemaDiff;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SchemaDiff {
    public static final Set<Difference.Type> COMPATIBLE_CHANGES;

    public static List<Difference> compare(ProtoFileElement original, ProtoFileElement update) {
        Context ctx = new Context(COMPATIBLE_CHANGES);
        SchemaDiff.compare(ctx, original, update);
        return ctx.getDifferences();
    }

    static void compare(Context ctx, ProtoFileElement original, ProtoFileElement update) {
        SchemaDiff.collectContextInfo(ctx, original.getTypes(), true);
        SchemaDiff.collectContextInfo(ctx, update.getTypes(), false);
        SchemaDiff.compareTypeElements(ctx, original.getTypes(), update.getTypes());
    }

    private static void collectContextInfo(Context ctx, List<TypeElement> types, boolean isOriginal) {
        for (TypeElement typeElement : types) {
            if (typeElement instanceof MessageElement) {
                MessageElement messageElement = (MessageElement)typeElement;
                Boolean isMapEntry = ProtobufSchema.findOption("map_entry", messageElement.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
                Optional<FieldElement> key = SchemaDiff.findField("key", messageElement.getFields());
                Optional<FieldElement> value = SchemaDiff.findField("value", messageElement.getFields());
                if (isMapEntry != null && key.isPresent() && value.isPresent()) {
                    ctx.addMap(messageElement.getName(), key.get(), value.get(), isOriginal);
                }
                SchemaDiff.collectContextInfo(ctx, messageElement.getNestedTypes(), isOriginal);
                continue;
            }
            if (!(typeElement instanceof EnumElement)) continue;
            ctx.addEnum(typeElement.getName(), isOriginal);
        }
    }

    public static Optional<FieldElement> findField(String name, List<FieldElement> options) {
        return options.stream().filter(o -> o.getName().equals(name)).findFirst();
    }

    public static void compareTypeElements(Context ctx, List<TypeElement> original, List<TypeElement> update) {
        Throwable throwable;
        Context.PathScope pathScope;
        HashMap<String, MessageElement> originalMessages = new HashMap<String, MessageElement>();
        HashMap<String, MessageElement> updateMessages = new HashMap<String, MessageElement>();
        HashMap<String, EnumElement> originalEnums = new HashMap<String, EnumElement>();
        HashMap<String, EnumElement> updateEnums = new HashMap<String, EnumElement>();
        SchemaDiff.compareMessageElements(original, originalMessages, originalEnums);
        SchemaDiff.compareMessageElements(update, updateMessages, updateEnums);
        HashSet allMessageNames = new HashSet(originalMessages.keySet());
        allMessageNames.addAll(updateMessages.keySet());
        HashSet allEnumNames = new HashSet(originalEnums.keySet());
        allEnumNames.addAll(updateEnums.keySet());
        for (String name : allMessageNames) {
            pathScope = ctx.enterPath(name);
            throwable = null;
            try {
                MessageElement originalMessage = (MessageElement)originalMessages.get(name);
                MessageElement updateMessage = (MessageElement)updateMessages.get(name);
                if (updateMessage == null) {
                    ctx.addDifference(Difference.Type.MESSAGE_REMOVED);
                    continue;
                }
                if (originalMessage == null) {
                    ctx.addDifference(Difference.Type.MESSAGE_ADDED);
                    continue;
                }
                MessageSchemaDiff.compare(ctx, originalMessage, updateMessage);
            }
            catch (Throwable originalMessage) {
                throwable = originalMessage;
                throw originalMessage;
            }
            finally {
                if (pathScope == null) continue;
                if (throwable != null) {
                    try {
                        pathScope.close();
                    }
                    catch (Throwable originalMessage) {
                        throwable.addSuppressed(originalMessage);
                    }
                    continue;
                }
                pathScope.close();
            }
        }
        for (String name : allEnumNames) {
            pathScope = ctx.enterPath(name);
            throwable = null;
            try {
                EnumElement originalEnum = (EnumElement)originalEnums.get(name);
                EnumElement updateEnum = (EnumElement)updateEnums.get(name);
                if (updateEnum == null) {
                    ctx.addDifference(Difference.Type.ENUM_REMOVED);
                    continue;
                }
                if (originalEnum == null) {
                    ctx.addDifference(Difference.Type.ENUM_ADDED);
                    continue;
                }
                EnumSchemaDiff.compare(ctx, originalEnum, updateEnum);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pathScope == null) continue;
                if (throwable != null) {
                    try {
                        pathScope.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pathScope.close();
            }
        }
    }

    private static void compareMessageElements(List<TypeElement> types, Map<String, MessageElement> messages, Map<String, EnumElement> enums) {
        for (TypeElement typeElement : types) {
            if (typeElement instanceof MessageElement) {
                MessageElement messageElement = (MessageElement)typeElement;
                messages.put(messageElement.getName(), messageElement);
                continue;
            }
            if (!(typeElement instanceof EnumElement)) continue;
            EnumElement enumElement = (EnumElement)typeElement;
            enums.put(enumElement.getName(), enumElement);
        }
    }

    static {
        HashSet<Difference.Type> changes = new HashSet<Difference.Type>();
        changes.add(Difference.Type.MESSAGE_ADDED);
        changes.add(Difference.Type.MESSAGE_REMOVED);
        changes.add(Difference.Type.ENUM_ADDED);
        changes.add(Difference.Type.ENUM_REMOVED);
        changes.add(Difference.Type.ENUM_CONST_ADDED);
        changes.add(Difference.Type.ENUM_CONST_CHANGED);
        changes.add(Difference.Type.ENUM_CONST_REMOVED);
        changes.add(Difference.Type.FIELD_ADDED);
        changes.add(Difference.Type.FIELD_REMOVED);
        changes.add(Difference.Type.FIELD_NAME_CHANGED);
        changes.add(Difference.Type.ONEOF_ADDED);
        changes.add(Difference.Type.ONEOF_REMOVED);
        changes.add(Difference.Type.ONEOF_FIELD_ADDED);
        COMPATIBLE_CHANGES = Collections.unmodifiableSet(changes);
    }
}

