/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.FieldElement;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import java.util.Objects;
import java.util.Optional;

public class FieldSchemaDiff {
    static void compare(Context ctx, FieldElement original, FieldElement update) {
        if (!Objects.equals(original.getName(), update.getName())) {
            ctx.addDifference(Difference.Type.FIELD_NAME_CHANGED);
        }
        ProtoType originalType = ProtoType.get((String)original.getType());
        ProtoType updateType = ProtoType.get((String)update.getType());
        FieldSchemaDiff.compareTypes(ctx, originalType, updateType);
    }

    static void compareTypes(Context ctx, ProtoType original, ProtoType update) {
        Kind updateKind;
        Kind originalKind;
        Optional<ProtoType> updateMap;
        Optional<ProtoType> originalMap = ctx.getMap(original.getSimpleName(), true);
        if (originalMap.isPresent()) {
            original = originalMap.get();
        }
        if ((updateMap = ctx.getMap(update.getSimpleName(), false)).isPresent()) {
            update = updateMap.get();
        }
        if (!Objects.equals((Object)(originalKind = FieldSchemaDiff.kind(ctx, original, true)), (Object)(updateKind = FieldSchemaDiff.kind(ctx, update, false)))) {
            ctx.addDifference(Difference.Type.FIELD_KIND_CHANGED);
        } else {
            switch (originalKind) {
                case SCALAR: {
                    FieldSchemaDiff.compareScalarTypes(ctx, original, update);
                    break;
                }
                case NAMED: {
                    FieldSchemaDiff.compareNamedTypes(ctx, original, update);
                    break;
                }
                case MAP: {
                    FieldSchemaDiff.compareMapTypes(ctx, original, update);
                    break;
                }
            }
        }
    }

    static void compareScalarTypes(Context ctx, ProtoType original, ProtoType update) {
        if (!Objects.equals((Object)FieldSchemaDiff.scalarKind(ctx, original, true), (Object)FieldSchemaDiff.scalarKind(ctx, update, false))) {
            ctx.addDifference(Difference.Type.FIELD_SCALAR_KIND_CHANGED);
        }
    }

    static void compareNamedTypes(Context ctx, ProtoType original, ProtoType update) {
        if (!Objects.equals(original.toString(), update.toString())) {
            ctx.addDifference(Difference.Type.FIELD_NAMED_TYPE_CHANGED);
        }
    }

    static void compareMapTypes(Context ctx, ProtoType original, ProtoType update) {
        FieldSchemaDiff.compareTypes(ctx, original.getKeyType(), update.getKeyType());
        FieldSchemaDiff.compareTypes(ctx, original.getValueType(), update.getValueType());
    }

    static Kind kind(Context ctx, ProtoType type, boolean isOriginal) {
        if (type.isScalar()) {
            return Kind.SCALAR;
        }
        if (type.isMap()) {
            return Kind.MAP;
        }
        if (ctx.containsEnum(type.getSimpleName(), isOriginal)) {
            return Kind.SCALAR;
        }
        return Kind.NAMED;
    }

    static ScalarKind scalarKind(Context ctx, ProtoType type, boolean isOriginal) {
        if (ctx.containsEnum(type.getSimpleName(), isOriginal)) {
            return ScalarKind.GENERAL_NUMBER;
        }
        switch (type.toString()) {
            case "int32": 
            case "int64": 
            case "uint32": 
            case "uint64": 
            case "bool": {
                return ScalarKind.GENERAL_NUMBER;
            }
            case "sint32": 
            case "sint64": {
                return ScalarKind.SIGNED_NUMBER;
            }
            case "string": 
            case "bytes": {
                return ScalarKind.STRING_OR_BYTES;
            }
            case "fixed32": 
            case "sfixed32": {
                return ScalarKind.FIXED32;
            }
            case "fixed64": 
            case "sfixed64": {
                return ScalarKind.FIXED64;
            }
            case "float": {
                return ScalarKind.FLOAT;
            }
            case "double": {
                return ScalarKind.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    static enum ScalarKind {
        GENERAL_NUMBER,
        SIGNED_NUMBER,
        STRING_OR_BYTES,
        FIXED32,
        FIXED64,
        FLOAT,
        DOUBLE,
        ANY;

    }

    static enum Kind {
        SCALAR,
        MAP,
        NAMED;

    }
}

