/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class Context {
    private final Set<Difference.Type> compatibleChanges;
    private final Set<MessageElement> schemas;
    private final Set<String> originalEnums;
    private final Set<String> updateEnums;
    private final Map<String, ProtoType> originalMaps;
    private final Map<String, ProtoType> updateMaps;
    private final Deque<String> fullPath;
    private final List<Difference> diffs;

    public Context(Set<Difference.Type> compatibleChanges) {
        this.compatibleChanges = compatibleChanges;
        this.schemas = Collections.newSetFromMap(new IdentityHashMap());
        this.originalEnums = new HashSet<String>();
        this.updateEnums = new HashSet<String>();
        this.originalMaps = new HashMap<String, ProtoType>();
        this.updateMaps = new HashMap<String, ProtoType>();
        this.fullPath = new ArrayDeque<String>();
        this.diffs = new ArrayList<Difference>();
    }

    public Context getSubcontext() {
        Context ctx = new Context(this.compatibleChanges);
        ctx.schemas.addAll(this.schemas);
        ctx.fullPath.addAll(this.fullPath);
        return ctx;
    }

    public SchemaScope enterSchema(MessageElement schema) {
        return !this.schemas.contains(schema) ? new SchemaScope(schema) : null;
    }

    public void addEnum(String name, boolean isOriginal) {
        if (isOriginal) {
            this.originalEnums.add(name);
        } else {
            this.updateEnums.add(name);
        }
    }

    public boolean containsEnum(String name, boolean isOriginal) {
        return isOriginal ? this.originalEnums.contains(name) : this.updateEnums.contains(name);
    }

    public void addMap(String name, FieldElement key, FieldElement value, boolean isOriginal) {
        ProtoType type = ProtoType.get((String)("map<" + key.getType() + ", " + value.getType() + ">"));
        if (isOriginal) {
            this.originalMaps.put(name, type);
        } else {
            this.updateMaps.put(name, type);
        }
    }

    public Optional<ProtoType> getMap(String name, boolean isOriginal) {
        return Optional.ofNullable(isOriginal ? this.originalMaps.get(name) : this.updateMaps.get(name));
    }

    public PathScope enterPath(String path) {
        return new PathScope(path);
    }

    public boolean isCompatible() {
        boolean notCompatible = this.getDifferences().stream().map(Difference::getType).anyMatch(t -> !this.compatibleChanges.contains(t));
        return !notCompatible;
    }

    public List<Difference> getDifferences() {
        return this.diffs;
    }

    public void addDifference(Difference.Type type) {
        this.diffs.add(new Difference(type, Context.fullPathString(this.fullPath)));
    }

    public void addDifference(String attribute, Difference.Type type) {
        this.fullPath.addLast(attribute);
        this.addDifference(type);
        this.fullPath.removeLast();
    }

    public void addDifferences(List<Difference> differences) {
        this.diffs.addAll(differences);
    }

    private static String fullPathString(Deque<String> fullPath) {
        return "#/" + String.join((CharSequence)"/", fullPath);
    }

    public class PathScope
    implements AutoCloseable {
        public PathScope(String path) {
            Context.this.fullPath.addLast(path);
        }

        @Override
        public void close() {
            Context.this.fullPath.removeLast();
        }
    }

    public class SchemaScope
    implements AutoCloseable {
        private final MessageElement schema;

        public SchemaScope(MessageElement schema) {
            this.schema = schema;
            Context.this.schemas.add(schema);
        }

        @Override
        public void close() {
            Context.this.schemas.remove(this.schema);
        }
    }
}

