/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.rules.RulePhase;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.json.JsonSchemaAndValue;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializerConfig;
import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public abstract class AbstractKafkaJsonSchemaDeserializer<T>
extends AbstractKafkaSchemaSerDe {
    protected ObjectMapper objectMapper = Jackson.newObjectMapper();
    protected Class<T> type;
    protected String typeProperty;
    protected boolean validate;

    protected void configure(KafkaJsonSchemaDeserializerConfig config, Class<T> type) {
        this.configureClientProperties(config, (SchemaProvider)new JsonSchemaProvider());
        this.type = type;
        boolean failUnknownProperties = config.getBoolean("json.fail.unknown.properties");
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failUnknownProperties);
        this.validate = config.getBoolean("json.fail.invalid.schema");
        this.typeProperty = config.getString("type.property");
    }

    protected KafkaJsonSchemaDeserializerConfig deserializerConfig(Map<String, ?> props) {
        try {
            return new KafkaJsonSchemaDeserializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected KafkaJsonSchemaDeserializerConfig deserializerConfig(Properties props) {
        return new KafkaJsonSchemaDeserializerConfig(props);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    protected T deserialize(byte[] payload) throws SerializationException, InvalidConfigurationException {
        return (T)this.deserialize(false, null, this.isKey, payload);
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, byte[] payload) throws SerializationException, InvalidConfigurationException {
        return this.deserialize(includeSchemaAndVersion, topic, isKey, null, payload);
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, Headers headers, byte[] payload) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the deserializer or use deserializer constructor with SchemaRegistryClient.");
        }
        if (payload == null) {
            return null;
        }
        SchemaId schemaId = new SchemaId("JSON");
        try {
            Object object;
            block42: {
                Object value;
                SchemaIdDeserializer schemaIdDeserializer;
                block40: {
                    block41: {
                        schemaIdDeserializer = this.schemaIdDeserializer(isKey);
                        try {
                            Object buf;
                            ByteBuffer buffer = schemaIdDeserializer.deserialize(topic, isKey.booleanValue(), headers, payload, schemaId);
                            String subject = isKey == null || this.strategyUsesSchema(isKey) ? this.getContextName(topic) : this.subjectName(topic, isKey, null);
                            JsonSchema schema = (JsonSchema)this.getSchemaBySchemaId(subject, schemaId);
                            if (isKey != null && this.strategyUsesSchema(isKey)) {
                                subject = this.subjectName(topic, isKey, schema);
                                schema = this.schemaForDeserialize(schemaId, schema, subject, isKey);
                            }
                            buffer = (buf = this.executeRules(subject, topic, headers, payload, RulePhase.ENCODING, RuleMode.READ, null, (ParsedSchema)schema, buffer)) instanceof byte[] ? ByteBuffer.wrap((byte[])buf) : (ByteBuffer)buf;
                            ParsedSchema readerSchema = null;
                            if (this.metadata != null) {
                                readerSchema = this.getLatestWithMetadata(subject).getSchema();
                            } else if (this.useLatestVersion) {
                                readerSchema = this.lookupLatestVersion(subject, (ParsedSchema)schema, false).getSchema();
                            }
                            if (includeSchemaAndVersion || readerSchema != null) {
                                Integer version = this.schemaVersion(topic, isKey, schemaId, subject, schema, null);
                                schema = schema.copy(version);
                            }
                            List migrations = Collections.emptyList();
                            if (readerSchema != null) {
                                migrations = this.getMigrations(subject, (ParsedSchema)schema, readerSchema);
                            }
                            int length = buffer.remaining();
                            int start = buffer.position() + buffer.arrayOffset();
                            JsonNode jsonNode = null;
                            if (!migrations.isEmpty()) {
                                jsonNode = (JsonNode)this.objectMapper.readValue(buffer.array(), start, length, JsonNode.class);
                                jsonNode = (JsonNode)this.executeMigrations(migrations, subject, topic, headers, jsonNode);
                            }
                            if (readerSchema != null) {
                                schema = (JsonSchema)readerSchema;
                            }
                            if (schema.ruleSet() != null && schema.ruleSet().hasRules(RulePhase.DOMAIN, RuleMode.READ)) {
                                if (jsonNode == null) {
                                    jsonNode = (JsonNode)this.objectMapper.readValue(buffer.array(), start, length, JsonNode.class);
                                }
                                jsonNode = (JsonNode)this.executeRules(subject, topic, headers, payload, RuleMode.READ, null, (ParsedSchema)schema, jsonNode);
                            }
                            if (this.validate) {
                                try {
                                    if (jsonNode == null) {
                                        jsonNode = (JsonNode)this.objectMapper.readValue(buffer.array(), start, length, JsonNode.class);
                                    }
                                    jsonNode = schema.validate(jsonNode);
                                }
                                catch (JsonProcessingException | ValidationException e) {
                                    throw new SerializationException("JSON " + String.valueOf(jsonNode) + " does not match schema " + schema.canonicalString(), e);
                                }
                            }
                            if (this.type != null && !Object.class.equals(this.type)) {
                                value = jsonNode != null ? this.objectMapper.convertValue((Object)jsonNode, this.type) : this.objectMapper.readValue(buffer.array(), start, length, this.type);
                            } else {
                                String typeName;
                                if (schema.has("oneOf") || schema.has("anyOf") || schema.has("allOf")) {
                                    if (jsonNode == null) {
                                        jsonNode = (JsonNode)this.objectMapper.readValue(buffer.array(), start, length, JsonNode.class);
                                    }
                                    typeName = this.getTypeName(schema.rawSchema(), jsonNode);
                                } else {
                                    typeName = schema.getString(this.typeProperty);
                                }
                                if (typeName != null) {
                                    value = jsonNode != null ? this.deriveType(jsonNode, typeName) : this.deriveType(buffer, length, start, typeName);
                                } else if (Object.class.equals(this.type)) {
                                    value = jsonNode != null ? this.objectMapper.convertValue((Object)jsonNode, this.type) : this.objectMapper.readValue(buffer.array(), start, length, this.type);
                                } else {
                                    Object object2 = value = jsonNode != null ? jsonNode : this.objectMapper.readTree((InputStream)new ByteArrayInputStream(buffer.array(), start, length));
                                }
                            }
                            if (!includeSchemaAndVersion) break block40;
                            object = new JsonSchemaAndValue(schema, value);
                            if (schemaIdDeserializer == null) break block41;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (schemaIdDeserializer != null) {
                                    try {
                                        schemaIdDeserializer.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (InterruptedIOException e) {
                                throw new TimeoutException("Error deserializing JSON message for id " + String.valueOf(schemaId), (Throwable)e);
                            }
                            catch (IOException | RuntimeException e) {
                                throw new SerializationException("Error deserializing JSON message for id " + String.valueOf(schemaId), (Throwable)e);
                            }
                            catch (RestClientException e) {
                                throw AbstractKafkaJsonSchemaDeserializer.toKafkaException((RestClientException)e, (String)("Error retrieving JSON schema for id " + String.valueOf(schemaId)));
                            }
                        }
                        schemaIdDeserializer.close();
                    }
                    return object;
                }
                object = value;
                if (schemaIdDeserializer == null) break block42;
                schemaIdDeserializer.close();
            }
            return object;
        }
        finally {
            this.postOp(payload);
        }
    }

    private String getTypeName(Schema schema, JsonNode jsonNode) {
        if (schema instanceof CombinedSchema) {
            for (Schema subschema : ((CombinedSchema)schema).getSubschemas()) {
                boolean valid = false;
                try {
                    JsonSchema.validate((Schema)subschema, (Object)jsonNode);
                    valid = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!valid) continue;
                return this.getTypeName(subschema, jsonNode);
            }
        } else if (schema instanceof ReferenceSchema) {
            return this.getTypeName(((ReferenceSchema)schema).getReferredSchema(), jsonNode);
        }
        return (String)schema.getUnprocessedProperties().get(this.typeProperty);
    }

    private Object deriveType(ByteBuffer buffer, int length, int start, String typeName) throws IOException {
        try {
            Class<?> cls = Class.forName(typeName);
            return this.objectMapper.readValue(buffer.array(), start, length, cls);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Class " + typeName + " could not be found.");
        }
    }

    private Object deriveType(JsonNode jsonNode, String typeName) throws IOException {
        try {
            Class<?> cls = Class.forName(typeName);
            return this.objectMapper.convertValue((Object)jsonNode, cls);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Class " + typeName + " could not be found.");
        }
    }

    private Integer schemaVersion(String topic, boolean isKey, SchemaId schemaId, String subject, JsonSchema schema, Object value) throws IOException, RestClientException {
        Integer version = null;
        JsonSchema subjectSchema = (JsonSchema)this.getSchemaBySchemaId(subject, schemaId);
        Metadata metadata = subjectSchema.metadata();
        if (metadata != null) {
            version = metadata.getConfluentVersionNumber();
        }
        if (version == null) {
            version = this.schemaRegistry.getVersion(subject, (ParsedSchema)subjectSchema);
        }
        return version;
    }

    private String subjectName(String topic, boolean isKey, JsonSchema schemaFromRegistry) {
        return this.getSubjectName(topic, isKey, null, (ParsedSchema)schemaFromRegistry);
    }

    private JsonSchema schemaForDeserialize(SchemaId schemaId, JsonSchema schemaFromRegistry, String subject, boolean isKey) throws IOException, RestClientException {
        return (JsonSchema)this.getSchemaBySchemaId(subject, schemaId);
    }

    protected JsonSchemaAndValue deserializeWithSchemaAndVersion(String topic, boolean isKey, Headers headers, byte[] payload) throws SerializationException {
        return (JsonSchemaAndValue)this.deserialize(true, topic, isKey, headers, payload);
    }
}

