/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaJsonSchemaSerializer<T>
extends AbstractKafkaJsonSchemaSerializer<T>
implements Serializer<T> {
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    private boolean isKey;
    private Cache<Class<?>, JsonSchema> schemaCache;

    public KafkaJsonSchemaSerializer() {
        this.schemaCache = new SynchronizedCache((Cache)new LRUCache(DEFAULT_CACHE_CAPACITY));
    }

    public KafkaJsonSchemaSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.schemaCache = new SynchronizedCache((Cache)new LRUCache(DEFAULT_CACHE_CAPACITY));
    }

    public KafkaJsonSchemaSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, DEFAULT_CACHE_CAPACITY);
    }

    public KafkaJsonSchemaSerializer(SchemaRegistryClient client, Map<String, ?> props, int cacheCapacity) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
        this.schemaCache = new SynchronizedCache((Cache)new LRUCache(cacheCapacity));
    }

    public void configure(Map<String, ?> config, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaJsonSchemaSerializerConfig(config));
    }

    public byte[] serialize(String topic, T record) {
        JsonSchema schema;
        if (record == null) {
            return null;
        }
        if (JsonSchemaUtils.isEnvelope(record)) {
            schema = this.getSchema(record);
        } else {
            schema = (JsonSchema)this.schemaCache.get(record.getClass());
            if (schema == null) {
                schema = this.getSchema(record);
                this.schemaCache.put(record.getClass(), (Object)schema);
            }
        }
        Object value = JsonSchemaUtils.getValue(record);
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, value, (ParsedSchema)schema), value, schema);
    }

    private JsonSchema getSchema(T record) {
        try {
            return JsonSchemaUtils.getSchema(record, (SpecificationVersion)this.specVersion, (boolean)this.oneofForNullables, (boolean)this.failUnknownProperties, (ObjectMapper)this.objectMapper, (SchemaRegistryClient)this.schemaRegistry);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void close() {
    }
}

