/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.SchemaLoaderConfig;
import com.github.erosb.jsonsKema.SchemaVisitor;
import com.github.erosb.jsonsKema.SourceLocation;
import com.github.erosb.jsonsKema.UnknownSource;
import com.github.erosb.jsonsKema.ValidationFailure;
import com.github.erosb.jsonsKema.Validator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.json.JsonSchemaComparator;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.json.schema.SchemaTranslator;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleConditionException;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(JsonSchema.class);
    public static final String DEFAULT_BASE_URI = "mem://input";
    public static final String TYPE = "JSON";
    public static final String TAGS = "confluent:tags";
    private static final String SCHEMA_KEYWORD = "$schema";
    private static final String PROPERTIES_KEYWORD = "properties";
    private static final Object NONE_MARKER = new Object();
    private final JsonNode jsonNode;
    private transient org.everit.json.schema.Schema schemaObj;
    private transient Schema skemaObj;
    private final Integer version;
    private final List<SchemaReference> references;
    private final Map<String, String> resolvedReferences;
    private final Metadata metadata;
    private final RuleSet ruleSet;
    private final boolean ignoreModernDialects;
    private transient String canonicalString;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final int DEFAULT_CACHE_CAPACITY = 1000;
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();
    private static final ObjectMapper objectMapperWithOrderedProps = Jackson.newObjectMapper(true);
    private static final Map<String, Map<String, BeanPropertyWriter>> beanGetters = new BoundedConcurrentHashMap(1000);
    private static final Map<String, Map<String, SettableBeanProperty>> beanSetters = new BoundedConcurrentHashMap(1000);
    private static final Map<URI, String> prepopulatedMetaSchemas = ImmutableMap.of((Object)URI.create("https://json-schema.org/draft/2019-09/schema"), (Object)JsonSchema.readFromClassPath("/metaschemas/draft/2019-09/schema"), (Object)URI.create("https://json-schema.org/draft/2019-09/meta/core"), (Object)JsonSchema.readFromClassPath("/metaschemas/draft/2019-09/meta/core"), (Object)URI.create("https://json-schema.org/draft/2019-09/meta/validation"), (Object)JsonSchema.readFromClassPath("/metaschemas/draft/2019-09/meta/validation"), (Object)URI.create("https://json-schema.org/draft/2019-09/meta/applicator"), (Object)JsonSchema.readFromClassPath("/metaschemas/draft/2019-09/meta/applicator"), (Object)URI.create("https://json-schema.org/draft/2019-09/meta/meta-data"), (Object)JsonSchema.readFromClassPath("/metaschemas/draft/2019-09/meta/meta-data"), (Object)URI.create("https://json-schema.org/draft/2019-09/meta/format"), (Object)JsonSchema.readFromClassPath("/metaschemas/draft/2019-09/meta/format"), (Object)URI.create("https://json-schema.org/draft/2019-09/meta/content"), (Object)JsonSchema.readFromClassPath("/metaschemas/draft/2019-09/meta/content"));

    public JsonSchema(JsonNode jsonNode) {
        this(jsonNode, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public JsonSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public JsonSchema(JsonNode jsonNode, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this.jsonNode = jsonNode;
        this.version = version;
        this.references = Collections.unmodifiableList(references);
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        this.metadata = null;
        this.ruleSet = null;
        this.ignoreModernDialects = false;
    }

    public JsonSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this(schemaString, references, resolvedReferences, null, null, version);
    }

    public JsonSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Metadata metadata, RuleSet ruleSet, Integer version) {
        try {
            this.jsonNode = schemaString != null ? objectMapper.readTree(schemaString) : null;
            this.version = version;
            this.references = Collections.unmodifiableList(references);
            this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
            this.metadata = metadata;
            this.ruleSet = ruleSet;
            this.ignoreModernDialects = false;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON " + schemaString, e);
        }
    }

    public JsonSchema(org.everit.json.schema.Schema schemaObj) {
        this(schemaObj, null);
    }

    public JsonSchema(org.everit.json.schema.Schema schemaObj, Integer version) {
        try {
            this.jsonNode = schemaObj != null ? objectMapper.readTree(schemaObj.toString()) : null;
            this.schemaObj = schemaObj;
            this.version = version;
            this.references = Collections.emptyList();
            this.resolvedReferences = Collections.emptyMap();
            this.metadata = null;
            this.ruleSet = null;
            this.ignoreModernDialects = false;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON " + schemaObj, e);
        }
    }

    private JsonSchema(JsonNode jsonNode, Schema skemaObj, org.everit.json.schema.Schema schemaObj, Integer version, List<SchemaReference> references, Map<String, String> resolvedReferences, Metadata metadata, RuleSet ruleSet, boolean ignoreModernDialects, String canonicalString) {
        this.jsonNode = jsonNode;
        this.skemaObj = skemaObj;
        this.schemaObj = schemaObj;
        this.version = version;
        this.references = references;
        this.resolvedReferences = resolvedReferences;
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.ignoreModernDialects = ignoreModernDialects;
        this.canonicalString = canonicalString;
    }

    public JsonSchema copy() {
        return new JsonSchema(this.jsonNode, this.skemaObj, this.schemaObj, this.version, this.references, this.resolvedReferences, this.metadata, this.ruleSet, this.ignoreModernDialects, this.canonicalString);
    }

    public JsonSchema copy(Integer version) {
        return new JsonSchema(this.jsonNode, this.skemaObj, this.schemaObj, version, this.references, this.resolvedReferences, this.metadata, this.ruleSet, this.ignoreModernDialects, this.canonicalString);
    }

    public JsonSchema copy(Metadata metadata, RuleSet ruleSet) {
        return new JsonSchema(this.jsonNode, this.skemaObj, this.schemaObj, this.version, this.references, this.resolvedReferences, metadata, ruleSet, this.ignoreModernDialects, this.canonicalString);
    }

    public ParsedSchema copy(Map<SchemaEntity, Set<String>> tagsToAdd, Map<SchemaEntity, Set<String>> tagsToRemove) {
        JsonSchema schemaCopy = this.copy();
        JsonNode original = schemaCopy.toJsonNode().deepCopy();
        this.modifySchemaTags(original, tagsToAdd, tagsToRemove);
        return new JsonSchema(original.toString(), schemaCopy.references(), schemaCopy.resolvedReferences(), schemaCopy.metadata(), schemaCopy.ruleSet(), schemaCopy.version());
    }

    public JsonSchema copyIgnoringModernDialects() {
        return new JsonSchema(this.jsonNode, null, null, this.version, this.references, this.resolvedReferences, this.metadata, this.ruleSet, true, this.canonicalString);
    }

    public JsonNode toJsonNode() {
        return this.jsonNode;
    }

    public org.everit.json.schema.Schema rawSchema() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.schemaObj == null) {
            try {
                if (this.jsonNode.isBoolean()) {
                    this.schemaObj = this.jsonNode.booleanValue() ? TrueSchema.builder().build() : FalseSchema.builder().build();
                } else {
                    String schema;
                    SpecificationVersion s;
                    SpecificationVersion spec = SpecificationVersion.DRAFT_7;
                    if (this.jsonNode.has(SCHEMA_KEYWORD) && (s = SpecificationVersion.getFromUrl(schema = this.jsonNode.get(SCHEMA_KEYWORD).asText())) != null) {
                        spec = s;
                    }
                    switch (spec) {
                        case DRAFT_2020_12: 
                        case DRAFT_2019_09: {
                            if (this.ignoreModernDialects) {
                                this.loadPreviousDraft(spec);
                                break;
                            }
                            this.loadLatestDraft();
                            break;
                        }
                        default: {
                            this.loadPreviousDraft(spec);
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Invalid JSON Schema", e);
            }
        }
        return this.schemaObj;
    }

    private void loadLatestDraft() throws URISyntaxException {
        HashMap<URI, String> mappings = new HashMap<URI, String>(prepopulatedMetaSchemas);
        for (Map.Entry<String, String> dep : this.resolvedReferences.entrySet()) {
            URI uri = new URI(dep.getKey());
            mappings.put(uri, dep.getValue());
            if (uri.isAbsolute() || dep.getKey().startsWith(".")) continue;
            mappings.put(new URI("./" + dep.getKey()), dep.getValue());
        }
        SchemaLoaderConfig config = SchemaLoaderConfig.createDefaultConfig(mappings);
        JsonValue schemaJson = (JsonValue)objectMapper.convertValue((Object)this.jsonNode, JsonObject.class);
        this.skemaObj = new com.github.erosb.jsonsKema.SchemaLoader((IJsonValue)schemaJson, config).load();
        SchemaTranslator.SchemaContext ctx = (SchemaTranslator.SchemaContext)this.skemaObj.accept((SchemaVisitor)new SchemaTranslator());
        assert (ctx != null);
        ctx.close();
        this.schemaObj = ctx.schema();
    }

    private void loadPreviousDraft(SpecificationVersion spec) throws JsonProcessingException {
        String id;
        org.everit.json.schema.loader.SpecificationVersion loaderSpec = org.everit.json.schema.loader.SpecificationVersion.DRAFT_7;
        switch (spec) {
            case DRAFT_7: {
                loaderSpec = org.everit.json.schema.loader.SpecificationVersion.DRAFT_7;
                break;
            }
            case DRAFT_6: {
                loaderSpec = org.everit.json.schema.loader.SpecificationVersion.DRAFT_6;
                break;
            }
            case DRAFT_4: {
                loaderSpec = org.everit.json.schema.loader.SpecificationVersion.DRAFT_4;
                break;
            }
        }
        URI idUri = null;
        if (this.jsonNode.has(loaderSpec.idKeyword()) && (id = this.jsonNode.get(loaderSpec.idKeyword()).asText()) != null) {
            idUri = ReferenceResolver.resolve((URI)null, (String)id);
        }
        SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().useDefaults(true).draftV7Support();
        for (Map.Entry<String, String> dep : this.resolvedReferences.entrySet()) {
            URI child = ReferenceResolver.resolve((URI)idUri, (String)dep.getKey());
            builder.registerSchemaByURI(child, (Object)new JSONObject(dep.getValue()));
        }
        JSONObject jsonObject = (JSONObject)objectMapper.treeToValue((TreeNode)this.jsonNode, JSONObject.class);
        builder.schemaJson(jsonObject);
        SchemaLoader loader = builder.build();
        this.schemaObj = loader.load().build();
    }

    public boolean hasTopLevelField(String field) {
        if (this.jsonNode != null) {
            JsonNode properties = this.jsonNode.get(PROPERTIES_KEYWORD);
            return properties instanceof ObjectNode && properties.has(field);
        }
        return false;
    }

    public String schemaType() {
        return TYPE;
    }

    public String name() {
        return this.getString("title");
    }

    public boolean has(String key) {
        return this.jsonNode.has(key);
    }

    public String getString(String key) {
        return this.jsonNode.has(key) ? this.jsonNode.get(key).asText() : null;
    }

    public String canonicalString() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.canonicalString == null) {
            try {
                this.canonicalString = objectMapper.writeValueAsString((Object)this.jsonNode);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON", e);
            }
        }
        return this.canonicalString;
    }

    public Integer version() {
        return this.version;
    }

    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.resolvedReferences;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public RuleSet ruleSet() {
        return this.ruleSet;
    }

    public boolean isIgnoreModernDialects() {
        return this.ignoreModernDialects;
    }

    public JsonSchema normalize() {
        String canonical = this.canonicalString();
        if (canonical == null) {
            return this;
        }
        try {
            JsonNode jsonNode = objectMapperWithOrderedProps.readTree(canonical);
            return new JsonSchema(jsonNode, this.references.stream().sorted().distinct().collect(Collectors.toList()), this.resolvedReferences, this.version);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
    }

    public void validate(boolean strict) {
        ObjectSchema schema;
        Optional<String> restrictedField;
        org.everit.json.schema.Schema rawSchema = this.rawSchema();
        if (strict && rawSchema instanceof ObjectSchema && (restrictedField = (schema = (ObjectSchema)rawSchema).getPropertySchemas().keySet().stream().filter(field -> field.startsWith("$$")).findAny()).isPresent()) {
            throw new ValidationException((org.everit.json.schema.Schema)schema, "Field names cannot start with $$ prefix", PROPERTIES_KEYWORD, String.format("#/properties/%s", restrictedField.get()));
        }
    }

    public JsonNode validate(JsonNode value) throws JsonProcessingException, ValidationException {
        if (this.skemaObj != null) {
            return JsonSchema.validate(this.skemaObj, value);
        }
        return JsonSchema.validate(this.rawSchema(), (Object)value);
    }

    public static JsonNode validate(Schema schema, JsonNode value) throws JsonProcessingException, ValidationException {
        ValidationFailure failure;
        Validator validator = Validator.forSchema((Schema)schema);
        JsonString primitiveValue = null;
        if (value instanceof BinaryNode) {
            primitiveValue = new JsonString(value.asText(), (SourceLocation)UnknownSource.INSTANCE);
        } else if (value instanceof BooleanNode) {
            primitiveValue = new JsonBoolean(value.asBoolean(), (SourceLocation)UnknownSource.INSTANCE);
        } else if (value instanceof NullNode) {
            primitiveValue = new JsonNull((SourceLocation)UnknownSource.INSTANCE);
        } else if (value instanceof NumericNode) {
            primitiveValue = new JsonNumber(value.numberValue(), (SourceLocation)UnknownSource.INSTANCE);
        } else if (value instanceof TextNode) {
            primitiveValue = new JsonString(value.asText(), (SourceLocation)UnknownSource.INSTANCE);
        }
        if (primitiveValue != null) {
            failure = validator.validate((IJsonValue)primitiveValue);
        } else {
            JsonValue jsonObject = value instanceof ArrayNode ? (JsonValue)objectMapper.convertValue((Object)value, JsonArray.class) : (JsonValue)objectMapper.convertValue((Object)value, JsonObject.class);
            failure = validator.validate((IJsonValue)jsonObject);
        }
        if (failure != null) {
            throw new ValidationException(failure.toString());
        }
        return value;
    }

    public static JsonNode validate(org.everit.json.schema.Schema schema, Object value) throws JsonProcessingException, ValidationException {
        Object primitiveValue = NONE_MARKER;
        if (JsonSchema.isPrimitive(value)) {
            primitiveValue = value;
        } else if (value instanceof BinaryNode) {
            primitiveValue = ((BinaryNode)value).asText();
        } else if (value instanceof BooleanNode) {
            primitiveValue = ((BooleanNode)value).asBoolean();
        } else if (value instanceof NullNode) {
            primitiveValue = null;
        } else if (value instanceof NumericNode) {
            primitiveValue = ((NumericNode)value).numberValue();
        } else if (value instanceof TextNode) {
            primitiveValue = ((TextNode)value).asText();
        }
        if (primitiveValue != NONE_MARKER) {
            schema.validate(primitiveValue);
            return value instanceof JsonNode ? (JsonNode)value : (JsonNode)objectMapper.convertValue(primitiveValue, JsonNode.class);
        }
        Object jsonObject = value instanceof ArrayNode ? objectMapper.treeToValue((TreeNode)((ArrayNode)value), JSONArray.class) : (value instanceof JsonNode ? objectMapper.treeToValue((TreeNode)((JsonNode)value), JSONObject.class) : (value.getClass().isArray() ? objectMapper.convertValue(value, JSONArray.class) : objectMapper.convertValue(value, JSONObject.class)));
        schema.validate(jsonObject);
        return (JsonNode)objectMapper.convertValue(jsonObject, JsonNode.class);
    }

    private static boolean isPrimitive(Object value) {
        return value == null || value instanceof Boolean || value instanceof Number || value instanceof String;
    }

    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Lists.newArrayList((Object[])new String[]{"Incompatible because of different schema type"});
        }
        List<Difference> differences = SchemaDiff.compare(((JsonSchema)previousSchema).rawSchema(), this.rawSchema());
        List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains((Object)diff.getType())).collect(Collectors.toList());
        boolean isCompatible = incompatibleDiffs.isEmpty();
        if (!isCompatible) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (Difference incompatibleDiff : incompatibleDiffs) {
                errorMessages.add(incompatibleDiff.toString());
            }
            return errorMessages;
        }
        return new ArrayList<String>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchema that = (JsonSchema)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.references, that.references) && Objects.equals(this.canonicalString(), that.canonicalString()) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet) && this.ignoreModernDialects == that.ignoreModernDialects;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.jsonNode, this.references, this.version, this.metadata, this.ruleSet, this.ignoreModernDialects);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.canonicalString();
    }

    public Object fromJson(JsonNode json) {
        return json;
    }

    public JsonNode toJson(Object message) throws IOException {
        if (message instanceof JsonNode) {
            return (JsonNode)message;
        }
        return objectMapper.readTree(JsonSchemaUtils.toJson(message));
    }

    public Object copyMessage(Object message) throws IOException {
        if (message instanceof JsonNode) {
            return ((JsonNode)message).deepCopy();
        }
        return this.toJson(message);
    }

    public Object transformMessage(RuleContext ctx, FieldTransform transform, Object message) throws RuleException {
        try {
            return this.toTransformedMessage(ctx, this.rawSchema(), "$", message, transform);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RuleException) {
                throw (RuleException)e.getCause();
            }
            throw e;
        }
    }

    private Object toTransformedMessage(RuleContext ctx, org.everit.json.schema.Schema schema, String path, Object message, FieldTransform transform) {
        RuleContext.FieldContext fieldCtx = ctx.currentField();
        if (schema == null) {
            return message;
        }
        message = this.getValue(message);
        if (fieldCtx != null) {
            fieldCtx.setType(this.getType(schema));
        }
        if (schema instanceof CombinedSchema) {
            JsonNode jsonNode = (JsonNode)objectMapper.convertValue(message, JsonNode.class);
            for (org.everit.json.schema.Schema subschema : ((CombinedSchema)schema).getSubschemas()) {
                boolean valid = false;
                try {
                    JsonSchema.validate(subschema, (Object)jsonNode);
                    valid = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!valid) continue;
                return this.toTransformedMessage(ctx, subschema, path, message, transform);
            }
            return message;
        }
        if (schema instanceof ArraySchema) {
            if (!(message instanceof Iterable)) {
                log.warn("Object does not match an array schema");
                return message;
            }
            org.everit.json.schema.Schema subschema = ((ArraySchema)schema).getAllItemSchema();
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            for (Object o : (Iterable)message) {
                result.add(this.toTransformedMessage(ctx, subschema, path + "[" + i + "]", o, transform));
                ++i;
            }
            return result;
        }
        if (schema instanceof ObjectSchema) {
            if (message == null) {
                return null;
            }
            Map propertySchemas = ((ObjectSchema)schema).getPropertySchemas();
            for (Map.Entry entry : propertySchemas.entrySet()) {
                String propertyName = (String)entry.getKey();
                org.everit.json.schema.Schema propertySchema = (org.everit.json.schema.Schema)entry.getValue();
                String fullName = path + "." + propertyName;
                RuleContext.FieldContext fc = ctx.enterField(message, fullName, propertyName, this.getType(propertySchema), this.getInlineTags(propertySchema));
                Throwable throwable = null;
                try {
                    if (fc == null) continue;
                    PropertyAccessor propertyAccessor = JsonSchema.getPropertyAccessor(ctx, message, propertyName);
                    Object value = propertyAccessor.getPropertyValue();
                    Object newValue = this.toTransformedMessage(ctx, propertySchema, fullName, value, transform);
                    if (ctx.rule().getKind() == RuleKind.CONDITION) {
                        if (!Boolean.FALSE.equals(newValue)) continue;
                        throw new RuntimeException((Throwable)new RuleConditionException(ctx.rule()));
                    }
                    propertyAccessor.setPropertyValue(newValue);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fc == null) continue;
                    if (throwable != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fc.close();
                }
            }
            return message;
        }
        if (schema instanceof ReferenceSchema) {
            if (message == null) {
                return null;
            }
            return this.toTransformedMessage(ctx, ((ReferenceSchema)schema).getReferredSchema(), path, message, transform);
        }
        if (schema instanceof ConditionalSchema || schema instanceof EmptySchema || schema instanceof FalseSchema || schema instanceof NotSchema) {
            return message;
        }
        if (fieldCtx != null) {
            try {
                SortedSet ruleTags = ctx.rule().getTags();
                if (ruleTags.isEmpty()) {
                    return transform.transform(ctx, fieldCtx, message);
                }
                if (!RuleContext.disjoint((Set)fieldCtx.getTags(), (Set)ruleTags)) {
                    return transform.transform(ctx, fieldCtx, message);
                }
            }
            catch (RuleException e) {
                throw new RuntimeException(e);
            }
        }
        return message;
    }

    private Object getValue(Object message) {
        if (message instanceof TextNode) {
            return ((TextNode)message).asText();
        }
        if (message instanceof NumericNode) {
            return ((NumericNode)message).numberValue();
        }
        if (message instanceof BooleanNode) {
            return ((BooleanNode)message).asBoolean();
        }
        if (message instanceof NullNode) {
            return null;
        }
        return message;
    }

    private RuleContext.Type getType(org.everit.json.schema.Schema schema) {
        if (schema instanceof ObjectSchema) {
            return JsonSchema.isMap((ObjectSchema)schema) ? RuleContext.Type.MAP : RuleContext.Type.RECORD;
        }
        if (schema instanceof ConstSchema || schema instanceof EnumSchema) {
            return RuleContext.Type.ENUM;
        }
        if (schema instanceof ArraySchema) {
            return RuleContext.Type.ARRAY;
        }
        if (schema instanceof CombinedSchema) {
            return RuleContext.Type.COMBINED;
        }
        if (schema instanceof StringSchema) {
            return RuleContext.Type.STRING;
        }
        if (schema instanceof NumberSchema) {
            NumberSchema numberSchema = (NumberSchema)schema;
            return numberSchema.requiresInteger() ? RuleContext.Type.INT : RuleContext.Type.DOUBLE;
        }
        if (schema instanceof BooleanSchema) {
            return RuleContext.Type.BOOLEAN;
        }
        return RuleContext.Type.NULL;
    }

    private static boolean isMap(ObjectSchema objectSchema) {
        return objectSchema.getPropertySchemas() == null || objectSchema.getPropertySchemas().isEmpty();
    }

    public Set<String> inlineTags() {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (this.jsonNode == null) {
            return tags;
        }
        this.getInlineTagsRecursively(tags, this.jsonNode);
        return tags;
    }

    private void getInlineTagsRecursively(Set<String> tags, JsonNode node) {
        tags.addAll(this.getInlineTags(node));
        node.forEach(n -> this.getInlineTagsRecursively(tags, (JsonNode)n));
    }

    public Map<SchemaEntity, Set<String>> inlineTaggedEntities() {
        LinkedHashMap<SchemaEntity, Set<String>> tags = new LinkedHashMap<SchemaEntity, Set<String>>();
        org.everit.json.schema.Schema schema = this.rawSchema();
        if (schema == null) {
            return tags;
        }
        this.getInlineTaggedEntitiesRecursively(tags, schema, "", false, new HashSet<String>());
        return tags;
    }

    private void getInlineTaggedEntitiesRecursively(Map<SchemaEntity, Set<String>> tags, org.everit.json.schema.Schema schema, String scope, boolean inField, Set<String> visited) {
        if (schema instanceof CombinedSchema) {
            CombinedSchema combinedSchema = (CombinedSchema)schema;
            String scopedName = scope + JsonSchemaComparator.getCriterion(combinedSchema);
            ArrayList<org.everit.json.schema.Schema> subschemas = new ArrayList<org.everit.json.schema.Schema>(combinedSchema.getSubschemas());
            subschemas.sort(new JsonSchemaComparator());
            for (int i = 0; i < subschemas.size(); ++i) {
                org.everit.json.schema.Schema subschema = (org.everit.json.schema.Schema)subschemas.get(i);
                this.getInlineTaggedEntitiesRecursively(tags, subschema, scopedName + "." + i + ".", false, visited);
            }
        } else if (schema instanceof ArraySchema) {
            org.everit.json.schema.Schema subschema = ((ArraySchema)schema).getAllItemSchema();
            this.getInlineTaggedEntitiesRecursively(tags, subschema, scope + "array.", false, visited);
        } else if (schema instanceof ObjectSchema) {
            Set<String> recordTags;
            ObjectSchema objectSchema = (ObjectSchema)schema;
            String scopedName = scope + "object";
            if (visited.contains(scopedName)) {
                return;
            }
            visited.add(scopedName);
            if (!inField && !(recordTags = this.getInlineTags(schema)).isEmpty()) {
                tags.put(new SchemaEntity(scopedName, SchemaEntity.EntityType.SR_RECORD), recordTags);
            }
            for (Map.Entry entry : objectSchema.getPropertySchemas().entrySet()) {
                String propertyName = (String)entry.getKey();
                org.everit.json.schema.Schema propertySchema = (org.everit.json.schema.Schema)entry.getValue();
                String scopedPropertyName = scopedName + "." + propertyName;
                Set<String> fieldTags = this.getInlineTags(propertySchema);
                if (!fieldTags.isEmpty()) {
                    tags.put(new SchemaEntity(scopedPropertyName, SchemaEntity.EntityType.SR_FIELD), fieldTags);
                }
                this.getInlineTaggedEntitiesRecursively(tags, propertySchema, scopedPropertyName + ".", true, visited);
            }
            this.getInlineTaggedEntitiesRecursively(tags, schema.getUnprocessedProperties(), scopedName + ".", visited);
        } else if (schema instanceof ConditionalSchema) {
            ConditionalSchema condSchema = (ConditionalSchema)schema;
            String scopedName = scope + "conditional";
            condSchema.getIfSchema().ifPresent(value -> this.getInlineTaggedEntitiesRecursively(tags, (org.everit.json.schema.Schema)value, scopedName + ".if.", false, visited));
            condSchema.getThenSchema().ifPresent(value -> this.getInlineTaggedEntitiesRecursively(tags, (org.everit.json.schema.Schema)value, scopedName + ".then.", false, visited));
            condSchema.getElseSchema().ifPresent(value -> this.getInlineTaggedEntitiesRecursively(tags, (org.everit.json.schema.Schema)value, scopedName + ".else.", false, visited));
        } else if (schema instanceof NotSchema) {
            org.everit.json.schema.Schema subschema = ((NotSchema)schema).getMustNotMatch();
            this.getInlineTaggedEntitiesRecursively(tags, subschema, scope + "not.", false, visited);
        }
    }

    private void getInlineTaggedEntitiesRecursively(Map<SchemaEntity, Set<String>> tags, Map<String, Object> unprocessedProperties, String scope, Set<String> visited) {
        Map defs;
        Map defns = (Map)unprocessedProperties.get("definitions");
        if (defns != null) {
            for (Map.Entry entry : defns.entrySet()) {
                Object rawSchema = null;
                if (entry.getValue() instanceof Map) {
                    rawSchema = this.replaceRefs((Map)entry.getValue());
                } else if (entry.getValue() instanceof List) {
                    rawSchema = this.replaceRefs((List)entry.getValue());
                }
                if (rawSchema == null) continue;
                JsonNode jsonNode = objectMapper.valueToTree(rawSchema);
                JsonSchema jsonSchema = new JsonSchema(jsonNode);
                this.getInlineTaggedEntitiesRecursively(tags, jsonSchema.rawSchema(), scope + "definitions." + (String)entry.getKey() + ".", false, visited);
            }
        }
        if ((defs = (Map)unprocessedProperties.get("$defs")) != null) {
            for (Map.Entry entry : defs.entrySet()) {
                if (!(entry.getValue() instanceof org.everit.json.schema.Schema)) continue;
                this.getInlineTaggedEntitiesRecursively(tags, (org.everit.json.schema.Schema)entry.getValue(), scope + "$defs." + (String)entry.getKey() + ".", false, visited);
            }
        }
    }

    private Map<String, Object> replaceRefs(Map<String, Object> defs) {
        HashMap<String, Object> result = new HashMap<String, Object>(defs);
        if (result.containsKey("$ref")) {
            result.put("$ref", "#");
        }
        for (Map.Entry entry : result.entrySet()) {
            if (entry.getValue() instanceof Map) {
                entry.setValue(this.replaceRefs((Map)entry.getValue()));
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            entry.setValue(this.replaceRefs((List)entry.getValue()));
        }
        return result;
    }

    private List<Object> replaceRefs(List<Object> items) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : items) {
            if (item instanceof Map) {
                result.add(this.replaceRefs((Map)item));
                continue;
            }
            if (item instanceof List) {
                result.add(this.replaceRefs((List)item));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private Set<String> getInlineTags(org.everit.json.schema.Schema schema) {
        Object prop = schema.getUnprocessedProperties().get(TAGS);
        if (prop instanceof List) {
            List tags = (List)prop;
            LinkedHashSet<String> result = new LinkedHashSet<String>(tags.size());
            for (Object tag : tags) {
                result.add(tag.toString());
            }
            return result;
        }
        return Collections.emptySet();
    }

    private Set<String> getInlineTags(JsonNode tagNode) {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (tagNode.has(TAGS)) {
            ArrayNode tagArray = (ArrayNode)tagNode.get(TAGS);
            tagArray.elements().forEachRemaining(tag -> tags.add(tag.asText()));
        }
        return tags;
    }

    private static PropertyAccessor getPropertyAccessor(RuleContext ctx, final Object message, final String propertyName) {
        if (message instanceof ObjectNode) {
            return new PropertyAccessor(){

                @Override
                public Object getPropertyValue() {
                    return ((ObjectNode)message).get(propertyName);
                }

                @Override
                public void setPropertyValue(Object value) {
                    ObjectNode objectNode = (ObjectNode)message;
                    if (value instanceof List) {
                        ArrayNode arrayNode = objectNode.putArray(propertyName);
                        ((List)value).forEach(v -> this.addArrayValue(arrayNode, v));
                    } else if (value instanceof JsonNode) {
                        objectNode.set(propertyName, (JsonNode)value);
                    } else if (value instanceof Boolean) {
                        objectNode.put(propertyName, (Boolean)value);
                    } else if (value instanceof BigDecimal) {
                        objectNode.put(propertyName, (BigDecimal)value);
                    } else if (value instanceof BigInteger) {
                        objectNode.put(propertyName, (BigInteger)value);
                    } else if (value instanceof Long) {
                        objectNode.put(propertyName, (Long)value);
                    } else if (value instanceof Double) {
                        objectNode.put(propertyName, (Double)value);
                    } else if (value instanceof Float) {
                        objectNode.put(propertyName, (Float)value);
                    } else if (value instanceof Integer) {
                        objectNode.put(propertyName, (Integer)value);
                    } else if (value instanceof Short) {
                        objectNode.put(propertyName, (Short)value);
                    } else if (value instanceof Byte) {
                        objectNode.put(propertyName, (short)((Byte)value).byteValue());
                    } else if (value instanceof byte[]) {
                        objectNode.put(propertyName, (byte[])value);
                    } else if (value == null) {
                        objectNode.putNull(propertyName);
                    } else {
                        objectNode.put(propertyName, value.toString());
                    }
                }

                private void addArrayValue(ArrayNode arrayNode, Object value) {
                    if (value instanceof JsonNode) {
                        arrayNode.add((JsonNode)value);
                    } else if (value instanceof Boolean) {
                        arrayNode.add((Boolean)value);
                    } else if (value instanceof BigDecimal) {
                        arrayNode.add((BigDecimal)value);
                    } else if (value instanceof BigInteger) {
                        arrayNode.add((BigInteger)value);
                    } else if (value instanceof Long) {
                        arrayNode.add((Long)value);
                    } else if (value instanceof Double) {
                        arrayNode.add((Double)value);
                    } else if (value instanceof Float) {
                        arrayNode.add((Float)value);
                    } else if (value instanceof Integer) {
                        arrayNode.add((Integer)value);
                    } else if (value instanceof Short) {
                        arrayNode.add((Short)value);
                    } else if (value instanceof Byte) {
                        arrayNode.add((short)((Byte)value).byteValue());
                    } else if (value instanceof byte[]) {
                        arrayNode.add((byte[])value);
                    } else {
                        arrayNode.add(value.toString());
                    }
                }
            };
        }
        final BeanPropertyWriter getter = JsonSchema.getBeanGetter(ctx, message, propertyName);
        final SettableBeanProperty setter = JsonSchema.getBeanSetter(ctx, message, propertyName);
        return new PropertyAccessor(){

            @Override
            public Object getPropertyValue() {
                try {
                    return getter.get(message);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not get property " + propertyName, e);
                }
            }

            @Override
            public void setPropertyValue(Object value) {
                try {
                    if (value instanceof Number) {
                        Number num = (Number)value;
                        Class cls = setter.getType().getRawClass();
                        if (cls == Byte.TYPE || cls == Byte.class) {
                            value = num.byteValue();
                        } else if (cls == Short.TYPE || cls == Short.class) {
                            value = num.shortValue();
                        } else if (cls == Integer.TYPE || cls == Integer.class) {
                            value = num.intValue();
                        } else if (cls == Long.TYPE || cls == Long.class) {
                            value = num.longValue();
                        } else if (cls == Float.TYPE || cls == Float.class) {
                            value = Float.valueOf(num.floatValue());
                        } else if (cls == Double.TYPE || cls == Double.class) {
                            value = num.doubleValue();
                        }
                    }
                    setter.set(message, value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not set property " + propertyName, e);
                }
            }
        };
    }

    private static BeanPropertyWriter getBeanGetter(RuleContext ctx, Object message, String propertyName) {
        Map props = beanGetters.computeIfAbsent(message.getClass().getName(), k -> {
            try {
                HashMap<String, BeanPropertyWriter> m = new HashMap<String, BeanPropertyWriter>();
                JsonSerializer ser = objectMapper.getSerializerProviderInstance().findValueSerializer(message.getClass());
                Iterator propIter = ser.properties();
                while (propIter.hasNext()) {
                    PropertyWriter p = (PropertyWriter)propIter.next();
                    if (!(p instanceof BeanPropertyWriter)) continue;
                    m.put(p.getName(), (BeanPropertyWriter)p);
                }
                return m;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not find JSON serializer for " + message.getClass(), e);
            }
        });
        return (BeanPropertyWriter)props.get(propertyName);
    }

    private static SettableBeanProperty getBeanSetter(RuleContext ctx, Object message, String propertyName) {
        Map props = beanSetters.computeIfAbsent(message.getClass().getName(), k -> {
            try {
                HashMap<String, SettableBeanProperty> m = new HashMap<String, SettableBeanProperty>();
                JavaType type = objectMapper.constructType(message.getClass());
                DefaultDeserializationContext ctxt = ((DefaultDeserializationContext.Impl)objectMapper.getDeserializationContext()).createDummyInstance(objectMapper.getDeserializationConfig());
                JsonDeserializer deser = ctxt.findNonContextualValueDeserializer(type);
                if (deser instanceof BeanDeserializer) {
                    Iterator propIter = ((BeanDeserializer)deser).properties();
                    while (propIter.hasNext()) {
                        SettableBeanProperty p = (SettableBeanProperty)propIter.next();
                        m.put(p.getName(), p);
                    }
                }
                return m;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not find JSON deserializer for " + message.getClass(), e);
            }
        });
        return (SettableBeanProperty)props.get(propertyName);
    }

    private void modifySchemaTags(JsonNode node, Map<SchemaEntity, Set<String>> tagsToAddMap, Map<SchemaEntity, Set<String>> tagsToRemoveMap) {
        LinkedHashSet<SchemaEntity> entityToModify = new LinkedHashSet<SchemaEntity>(tagsToAddMap.keySet());
        entityToModify.addAll(tagsToRemoveMap.keySet());
        for (SchemaEntity entity : entityToModify) {
            Set<String> tagsToRemove;
            JsonNode fieldNodePtr = JsonSchemaUtils.findMatchingEntity(node, entity);
            Set<String> allTags = this.getInlineTags(fieldNodePtr);
            Set<String> tagsToAdd = tagsToAddMap.get(entity);
            if (tagsToAdd != null && !tagsToAdd.isEmpty()) {
                allTags.addAll(tagsToAdd);
            }
            if ((tagsToRemove = tagsToRemoveMap.get(entity)) != null && !tagsToRemove.isEmpty()) {
                allTags.removeAll(tagsToRemove);
            }
            if (allTags.isEmpty()) {
                ((ObjectNode)fieldNodePtr).remove(TAGS);
                continue;
            }
            ((ObjectNode)fieldNodePtr).replace(TAGS, objectMapper.valueToTree(allTags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromClassPath(String absPath) {
        InputStream is = JsonSchema.class.getResourceAsStream(absPath);
        if (is != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                return string;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new IllegalArgumentException("Could not load resource " + absPath);
    }

    static interface PropertyAccessor {
        public Object getPropertyValue();

        public void setPropertyValue(Object var1);
    }
}

