/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.partitioner;

import io.confluent.connect.storage.common.SchemaGenerator;
import io.confluent.connect.storage.partitioner.Partitioner;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.sink.SinkRecord;

public class DefaultPartitioner<T>
implements Partitioner<T> {
    private static final String PARTITION_FIELD = "partition";
    private static final String SCHEMA_GENERATOR_CLASS = "io.confluent.connect.storage.hive.schema.DefaultSchemaGenerator";
    protected Map<String, Object> config;
    protected List<T> partitionFields = null;
    protected String delim;

    @Override
    public void configure(Map<String, Object> config) {
        this.config = config;
        this.delim = (String)config.get("directory.delim");
    }

    @Override
    public String encodePartition(SinkRecord sinkRecord) {
        return "partition=" + String.valueOf(sinkRecord.kafkaPartition());
    }

    @Override
    public String generatePartitionedPath(String topic, String encodedPartition) {
        return topic + this.delim + encodedPartition;
    }

    @Override
    public List<T> partitionFields() {
        if (this.partitionFields == null) {
            this.partitionFields = this.newSchemaGenerator(this.config).newPartitionFields(PARTITION_FIELD);
        }
        return this.partitionFields;
    }

    public SchemaGenerator<T> newSchemaGenerator(Map<String, Object> config) {
        Class<SchemaGenerator<T>> generatorClass = null;
        try {
            generatorClass = this.getSchemaGeneratorClass();
            return generatorClass.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            ConfigException ce = new ConfigException("Invalid generator class: " + generatorClass);
            ce.initCause((Throwable)e);
            throw ce;
        }
    }

    protected Class<? extends SchemaGenerator<T>> getSchemaGeneratorClass() throws ClassNotFoundException {
        return Class.forName(SCHEMA_GENERATOR_CLASS);
    }
}

