/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class HiveSchemaConverter {
    private static final Map<Schema.Type, TypeInfo> TYPE_TO_TYPEINFO = new HashMap<Schema.Type, TypeInfo>();
    protected static final String CONNECT_AVRO_DECIMAL_PRECISION_PROP = "connect.decimal.precision";
    protected static final int HIVE_DECIMAL_PRECISION_MAX = 38;

    public static List<FieldSchema> convertSchema(Schema schema) {
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>();
        if (Schema.Type.STRUCT.equals((Object)schema.type())) {
            for (Field field : schema.fields()) {
                columns.add(new FieldSchema(field.name(), HiveSchemaConverter.convert(field.schema()).getTypeName(), field.schema().doc()));
            }
        }
        return columns;
    }

    public static List<FieldSchema> convertSchemaMaybeLogical(Schema schema) {
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>();
        if (Schema.Type.STRUCT.equals((Object)schema.type())) {
            for (Field field : schema.fields()) {
                columns.add(new FieldSchema(field.name(), HiveSchemaConverter.convertMaybeLogical(field.schema()).getTypeName(), field.schema().doc()));
            }
        }
        return columns;
    }

    public static TypeInfo convert(Schema schema, boolean convertLogical) {
        switch (schema.type()) {
            case STRUCT: {
                return HiveSchemaConverter.convertStruct(schema, convertLogical);
            }
            case ARRAY: {
                return HiveSchemaConverter.convertArray(schema, convertLogical);
            }
            case MAP: {
                return HiveSchemaConverter.convertMap(schema, convertLogical);
            }
        }
        return convertLogical ? HiveSchemaConverter.convertPrimitiveMaybeLogical(schema) : HiveSchemaConverter.convertPrimitive(schema);
    }

    public static TypeInfo convert(Schema schema) {
        return HiveSchemaConverter.convert(schema, false);
    }

    public static TypeInfo convertMaybeLogical(Schema schema) {
        return HiveSchemaConverter.convert(schema, true);
    }

    public static TypeInfo convertStruct(Schema schema, boolean convertLogical) {
        List fields = schema.fields();
        ArrayList<String> names = new ArrayList<String>(fields.size());
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>(fields.size());
        for (Field field : fields) {
            names.add(field.name());
            types.add(HiveSchemaConverter.convert(field.schema(), convertLogical));
        }
        return TypeInfoFactory.getStructTypeInfo(names, types);
    }

    public static TypeInfo convertStruct(Schema schema) {
        return HiveSchemaConverter.convertStruct(schema, false);
    }

    public static TypeInfo convertArray(Schema schema, boolean convertLogical) {
        return TypeInfoFactory.getListTypeInfo((TypeInfo)HiveSchemaConverter.convert(schema.valueSchema(), convertLogical));
    }

    public static TypeInfo convertArray(Schema schema) {
        return HiveSchemaConverter.convertArray(schema, false);
    }

    public static TypeInfo convertMap(Schema schema, boolean convertLogical) {
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)HiveSchemaConverter.convert(schema.keySchema(), convertLogical), (TypeInfo)HiveSchemaConverter.convert(schema.valueSchema(), convertLogical));
    }

    public static TypeInfo convertMap(Schema schema) {
        return HiveSchemaConverter.convertMap(schema, false);
    }

    public static TypeInfo convertPrimitive(Schema schema) {
        return TYPE_TO_TYPEINFO.get(schema.type());
    }

    public static TypeInfo convertPrimitiveMaybeLogical(Schema schema) {
        if (schema.name() == null) {
            return HiveSchemaConverter.convertPrimitive(schema);
        }
        switch (schema.name()) {
            case "org.apache.kafka.connect.data.Decimal": {
                String scale = (String)schema.parameters().get("scale");
                String precision = (String)schema.parameters().get(CONNECT_AVRO_DECIMAL_PRECISION_PROP);
                if (precision != null && Integer.parseInt(precision) > 38) {
                    throw new ConnectException(String.format("Illegal precision %s : Hive allows at most %d precision.", precision, 38));
                }
                return new DecimalTypeInfo(38, Integer.parseInt(scale));
            }
            case "org.apache.kafka.connect.data.Date": {
                return TypeInfoFactory.dateTypeInfo;
            }
            case "org.apache.kafka.connect.data.Timestamp": {
                return TypeInfoFactory.timestampTypeInfo;
            }
        }
        return HiveSchemaConverter.convertPrimitive(schema);
    }

    static {
        TYPE_TO_TYPEINFO.put(Schema.Type.BOOLEAN, (TypeInfo)TypeInfoFactory.booleanTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT8, (TypeInfo)TypeInfoFactory.byteTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT16, (TypeInfo)TypeInfoFactory.shortTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT32, (TypeInfo)TypeInfoFactory.intTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.INT64, (TypeInfo)TypeInfoFactory.longTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.FLOAT32, (TypeInfo)TypeInfoFactory.floatTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.FLOAT64, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.BYTES, (TypeInfo)TypeInfoFactory.binaryTypeInfo);
        TYPE_TO_TYPEINFO.put(Schema.Type.STRING, (TypeInfo)TypeInfoFactory.stringTypeInfo);
    }
}

