/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.storage.common;

import io.confluent.connect.storage.common.ComposableConfig;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class StorageCommonConfig
extends AbstractConfig
implements ComposableConfig {
    public static final String STORAGE_CLASS_CONFIG = "storage.class";
    public static final String STORAGE_CLASS_DOC = "The underlying storage layer.";
    public static final String STORAGE_CLASS_DISPLAY = "Storage Class";
    public static final String STORE_URL_CONFIG = "store.url";
    public static final String STORE_URL_DOC = "Store's connection URL, if applicable.";
    public static final String STORE_URL_DEFAULT = null;
    public static final String STORE_URL_DISPLAY = "Store URL";
    public static final String TOPICS_DIR_CONFIG = "topics.dir";
    public static final String TOPICS_DIR_DOC = "Top level directory to store the data ingested from Kafka.";
    public static final String TOPICS_DIR_DEFAULT = "topics";
    public static final String TOPICS_DIR_DISPLAY = "Topics directory";
    public static final String DIRECTORY_DELIM_CONFIG = "directory.delim";
    public static final String DIRECTORY_DELIM_DOC = "Directory delimiter pattern";
    public static final String DIRECTORY_DELIM_DEFAULT = "/";
    public static final String DIRECTORY_DELIM_DISPLAY = "Directory Delimiter";
    public static final String FILE_DELIM_CONFIG = "file.delim";
    public static final String FILE_DELIM_DOC = "File delimiter pattern";
    public static final String FILE_DELIM_DEFAULT = "+";
    public static final String FILE_DELIM_DISPLAY = "File Delimiter";

    public static ConfigDef newConfigDef(ConfigDef.Recommender storageClassRecommender) {
        ConfigDef configDef = new ConfigDef();
        String group = "Storage";
        int orderInGroup = 0;
        configDef.define(STORAGE_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, STORAGE_CLASS_DOC, "Storage", ++orderInGroup, ConfigDef.Width.NONE, STORAGE_CLASS_DISPLAY, storageClassRecommender);
        configDef.define(TOPICS_DIR_CONFIG, ConfigDef.Type.STRING, (Object)TOPICS_DIR_DEFAULT, ConfigDef.Importance.HIGH, TOPICS_DIR_DOC, "Storage", ++orderInGroup, ConfigDef.Width.NONE, TOPICS_DIR_DISPLAY);
        configDef.define(STORE_URL_CONFIG, ConfigDef.Type.STRING, (Object)STORE_URL_DEFAULT, ConfigDef.Importance.HIGH, STORE_URL_DOC, "Storage", ++orderInGroup, ConfigDef.Width.NONE, STORE_URL_DISPLAY);
        configDef.define(DIRECTORY_DELIM_CONFIG, ConfigDef.Type.STRING, (Object)DIRECTORY_DELIM_DEFAULT, ConfigDef.Importance.MEDIUM, DIRECTORY_DELIM_DOC, "Storage", ++orderInGroup, ConfigDef.Width.LONG, DIRECTORY_DELIM_DISPLAY);
        configDef.define(FILE_DELIM_CONFIG, ConfigDef.Type.STRING, (Object)FILE_DELIM_DEFAULT, ConfigDef.Importance.MEDIUM, FILE_DELIM_DOC, "Storage", ++orderInGroup, ConfigDef.Width.LONG, FILE_DELIM_DISPLAY);
        return configDef;
    }

    @Override
    public Object get(String key) {
        return super.get(key);
    }

    public StorageCommonConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
    }
}

