/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.storage;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.kafka.connect.errors.ConnectException;

public enum CompressionType {
    NONE("none", ""),
    GZIP("gzip", ".gz"){

        @Override
        public OutputStream wrapForOutput(OutputStream out) {
            return this.wrapForOutput(out, -1);
        }

        @Override
        public OutputStream wrapForOutput(OutputStream out, int level) {
            try {
                return new GZIPOutputStream(out, 8192){

                    public OutputStream setLevel(int level) {
                        this.def.setLevel(level);
                        return this;
                    }
                }.setLevel(level);
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e);
            }
        }

        @Override
        public InputStream wrapForInput(InputStream in) {
            try {
                return new GZIPInputStream(in);
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e);
            }
        }

        @Override
        public void finalize(OutputStream compressionFilter) {
            if (compressionFilter instanceof DeflaterOutputStream) {
                try {
                    ((DeflaterOutputStream)compressionFilter).finish();
                }
                catch (Exception e) {
                    throw new ConnectException((Throwable)e);
                }
            } else {
                throw new ConnectException("Expected compressionFilter to be a DeflaterOutputStream, but was passed an instance that does not match that type.");
            }
        }
    };

    private static final int GZIP_BUFFER_SIZE_BYTES = 8192;
    public final String name;
    public final String extension;

    private CompressionType(String name, String extension) {
        this.name = name;
        this.extension = extension;
    }

    public static CompressionType forName(String name) {
        if (CompressionType.NONE.name.equals(name)) {
            return NONE;
        }
        if (CompressionType.GZIP.name.equals(name)) {
            return GZIP;
        }
        throw new IllegalArgumentException("Unknown compression name: " + name);
    }

    public OutputStream wrapForOutput(OutputStream out) {
        return out;
    }

    public OutputStream wrapForOutput(OutputStream out, int level) {
        return this.wrapForOutput(out);
    }

    public InputStream wrapForInput(InputStream in) {
        return in;
    }

    public void finalize(OutputStream compressionFilter) {
    }
}

