/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format;

import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.util.Utils;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueHeaderRecordWriterProvider
implements RecordWriterProvider<S3SinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(KeyValueHeaderRecordWriterProvider.class);
    @NotNull
    private final RecordWriterProvider<S3SinkConnectorConfig> valueProvider;
    @Nullable
    private final RecordWriterProvider<S3SinkConnectorConfig> keyProvider;
    @Nullable
    private final RecordWriterProvider<S3SinkConnectorConfig> headerProvider;

    public KeyValueHeaderRecordWriterProvider(RecordWriterProvider<S3SinkConnectorConfig> valueProvider, @Nullable RecordWriterProvider<S3SinkConnectorConfig> keyProvider, @Nullable RecordWriterProvider<S3SinkConnectorConfig> headerProvider) {
        this.valueProvider = Objects.requireNonNull(valueProvider);
        this.keyProvider = keyProvider;
        this.headerProvider = headerProvider;
    }

    public String getExtension() {
        return this.valueProvider.getExtension();
    }

    public RecordWriter getRecordWriter(S3SinkConnectorConfig conf, String filename) {
        String strippedFilename = filename.endsWith(this.valueProvider.getExtension()) ? filename.substring(0, filename.length() - this.valueProvider.getExtension().length()) : filename;
        final RecordWriter valueWriter = this.valueProvider.getRecordWriter((Object)conf, strippedFilename);
        final RecordWriter keyWriter = this.keyProvider == null ? null : this.keyProvider.getRecordWriter((Object)conf, strippedFilename);
        final RecordWriter headerWriter = this.headerProvider == null ? null : this.headerProvider.getRecordWriter((Object)conf, strippedFilename);
        return new RecordWriter(){

            public void write(SinkRecord sinkRecord) {
                if (keyWriter != null && sinkRecord.key() == null) {
                    throw new DataException(String.format("Key cannot be null for SinkRecord: %s", Utils.sinkRecordToLoggableString(sinkRecord)));
                }
                if (headerWriter != null && (sinkRecord.headers() == null || sinkRecord.headers().isEmpty())) {
                    throw new DataException(String.format("Headers cannot be null for SinkRecord: %s", Utils.sinkRecordToLoggableString(sinkRecord)));
                }
                valueWriter.write(sinkRecord);
                if (keyWriter != null) {
                    keyWriter.write(sinkRecord);
                }
                if (headerWriter != null) {
                    headerWriter.write(sinkRecord);
                }
            }

            public void close() {
                valueWriter.close();
                if (keyWriter != null) {
                    keyWriter.close();
                }
                if (headerWriter != null) {
                    headerWriter.close();
                }
            }

            public void commit() {
                valueWriter.commit();
                if (keyWriter != null) {
                    keyWriter.commit();
                }
                if (headerWriter != null) {
                    headerWriter.commit();
                }
            }
        };
    }
}

