/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticatorConfig;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtVerificationException;
import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.security.util.JwtUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtAuthenticator
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_SCOPE_CLAIM = "scope";
    private final JwtConsumer jwtConsumer;
    private final String issuer;
    private final CloseableVerificationKeyResolver keyResolver;

    public JwtAuthenticator(String issuer, CloseableVerificationKeyResolver keyResolver, List<String> audience, boolean audienceRequired) {
        if (issuer == null || issuer.isEmpty()) {
            throw new IllegalArgumentException("Issuer must not be null or empty");
        }
        Objects.requireNonNull(keyResolver, "keyResolver is a required parameter which must not be null");
        this.issuer = issuer;
        this.keyResolver = keyResolver;
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setExpectedIssuer(issuer).setVerificationKeyResolver((VerificationKeyResolver)keyResolver).setRequireExpirationTime().setRequireIssuedAt().setRequireJwtId().setRequireSubject();
        if (audience != null && audience.size() != 0) {
            String[] audList = new String[audience.size()];
            audList = audience.toArray(audList);
            jwtConsumerBuilder.setExpectedAudience(audienceRequired, audList);
        }
        this.jwtConsumer = jwtConsumerBuilder.build();
    }

    public JwtAuthenticator(String issuer, CloseableVerificationKeyResolver keyResolver) {
        this(issuer, keyResolver, null, false);
    }

    public JwtAuthenticator(JwtAuthenticatorConfig config) {
        this(config.issuer(), config.verificationKeyResolver(), config.audience(), config.audienceRequired());
    }

    public OAuthBearerToken login(String jws, String scopeClaim) throws JwtVerificationException {
        try {
            JwtClaims claims = this.jwtConsumer.processToClaims(jws);
            HashSet<String> scope = scopeClaim == "orgResourceId" ? new HashSet<String>(Arrays.asList(claims.getStringClaimValue(scopeClaim))) : new HashSet<String>(claims.getStringListClaimValue(scopeClaim));
            return new OAuthBearerJwsToken(jws, scope, claims.getExpirationTime().getValueInMillis(), claims.getSubject(), claims.getIssuedAt().getValueInMillis(), claims.getClaimsMap(), claims.getIssuer());
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            this.log.debug("Failed to process token {}", (Object)e.getMessage());
            throw new JwtVerificationException("Failed to validate authentication token : " + JwtUtils.errorMessage((Throwable)e));
        }
    }

    public OAuthBearerToken login(String jws) throws JwtVerificationException {
        return this.login(jws, DEFAULT_SCOPE_CLAIM);
    }

    public OAuthBearerToken login(OAuthBearerToken token) throws JwtVerificationException {
        return this.login(token.value(), DEFAULT_SCOPE_CLAIM);
    }

    public static String extractSignature(OAuthBearerToken jwt) {
        Objects.requireNonNull(jwt, "JwtBearerToken must not be null");
        try {
            return ((JsonWebSignature)JsonWebSignature.fromCompactSerialization((String)jwt.value())).getEncodedSignature();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid JWS", e);
        }
    }

    public String issuer() {
        return this.issuer;
    }

    @Override
    public void close() throws IOException {
        this.keyResolver.close();
    }
}

