/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.fips;

import io.confluent.kafka.security.fips.exceptions.InvalidFipsBrokerProtocolException;
import io.confluent.kafka.security.fips.exceptions.InvalidFipsTlsCipherSuiteException;
import io.confluent.kafka.security.fips.exceptions.InvalidFipsTlsVersionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.fips.FipsValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentFipsValidator
implements FipsValidator {
    private static final Logger log = LoggerFactory.getLogger(ConfluentFipsValidator.class);
    private static final Set<String> ALLOWED_CIPHER_SUITES = Stream.of("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CCM", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CCM").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> ALLOWED_TLS_PROTOCOLS = Stream.of("TLSv1.2").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> ALLOWED_BROKER_PROTOCOLS = Stream.of("SASL_SSL", "SSL").collect(Collectors.toCollection(HashSet::new));
    private static final String ERROR_CIPHER_SUITES = "FIPS 140-2 Configuration Error, invalid cipher suites: ";
    private static final String ERROR_TLS_VERSIONS = "FIPS 140-2 Configuration Error, invalid TLS versions: ";
    private static final String ERROR_BROKER_PROTOCOLS = "FIPS 140-2 Configuration Error, invalid broker protocols: ";

    public boolean fipsEnabled() {
        return true;
    }

    public void validateFipsTls(Map<String, ?> configs) {
        this.validateFipsTlsCipherSuite(configs);
        this.validateFipsTlsVersion(configs);
    }

    public void validateFipsBrokerProtocol(Map<String, SecurityProtocol> securityProtocolMap) {
        List<Object> violatedBrokerProtocols = new ArrayList();
        violatedBrokerProtocols = securityProtocolMap.entrySet().stream().filter(entry -> !ALLOWED_BROKER_PROTOCOLS.contains(((SecurityProtocol)entry.getValue()).name)).map(entry -> (String)entry.getKey() + ":" + ((SecurityProtocol)entry.getValue()).name).collect(Collectors.toList());
        if (!violatedBrokerProtocols.isEmpty()) {
            String exmsg = String.format("%s%s", ERROR_BROKER_PROTOCOLS, String.join((CharSequence)",", violatedBrokerProtocols));
            log.error(exmsg);
            throw new InvalidFipsBrokerProtocolException(exmsg);
        }
    }

    public void validateFipsTlsCipherSuite(Map<String, ?> configs) {
        List cipherSuitesList = (List)configs.get("ssl.cipher.suites");
        this.validateFipsTlsCipherSuite(cipherSuitesList);
    }

    public void validateFipsTlsVersion(Map<String, ?> configs) {
        List tlsVersionList = (List)configs.get("ssl.enabled.protocols");
        this.validateFipsTlsVersion(tlsVersionList);
    }

    public void validateFipsTlsCipherSuite(Collection<String> cipherSuites) {
        List<Object> violatedCiphers = new ArrayList();
        if (cipherSuites != null && !cipherSuites.isEmpty()) {
            violatedCiphers = cipherSuites.stream().filter(cipher -> !ALLOWED_CIPHER_SUITES.contains(cipher)).collect(Collectors.toList());
        }
        if (!violatedCiphers.isEmpty()) {
            String exmsg = String.format("%s%s", ERROR_CIPHER_SUITES, String.join((CharSequence)",", violatedCiphers));
            log.error(exmsg);
            throw new InvalidFipsTlsCipherSuiteException(exmsg);
        }
    }

    public void validateFipsTlsVersion(Collection<String> tlsVersions) {
        List<Object> violatedTlsVersions = new ArrayList();
        if (tlsVersions != null && !tlsVersions.isEmpty()) {
            violatedTlsVersions = tlsVersions.stream().filter(protocol -> !ALLOWED_TLS_PROTOCOLS.contains(protocol)).collect(Collectors.toList());
        }
        if (!violatedTlsVersions.isEmpty()) {
            String exmsg = String.format("%s%s", ERROR_TLS_VERSIONS, String.join((CharSequence)",", violatedTlsVersions));
            log.error(exmsg);
            throw new InvalidFipsTlsVersionException(exmsg);
        }
    }
}

