/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.token.AbstractTokenLoginCallbackHandler;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.auth.client.rest.RestClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUserLoginCallbackHandler
extends AbstractTokenLoginCallbackHandler {
    private final Logger log = LoggerFactory.getLogger(TokenUserLoginCallbackHandler.class);
    private RestClient restClient;

    @Override
    public void configure(Map<String, ?> configs) {
        HashMap tempConfigs = new HashMap(configs);
        String user = (String)tempConfigs.get("username");
        String pass = (String)tempConfigs.get("password");
        if (user.isEmpty() || pass.isEmpty()) {
            throw new ConfigException(String.format("Both %s and %s are required and have no default values.", "username", "password"));
        }
        tempConfigs.put("confluent.metadata.http.auth.credentials.provider", BuiltInAuthProviders.HttpCredentialProviders.BASIC.name());
        tempConfigs.put("confluent.metadata.basic.auth.user.info", String.join((CharSequence)":", user, pass));
        this.restClient = new RestClient(tempConfigs);
    }

    @Override
    void attachAuthToken(OAuthBearerTokenCallback callback) {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had an Authentication Token already");
        }
        callback.token((OAuthBearerToken)this.restClient.login());
    }

    @Override
    public void close() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

