/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.token.AbstractTokenLoginCallbackHandler;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.auth.client.rest.RestClient;
import io.confluent.security.auth.common.JwtBearerToken;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBearerLoginCallbackHandler
extends AbstractTokenLoginCallbackHandler {
    private final Logger log = LoggerFactory.getLogger(TokenBearerLoginCallbackHandler.class);
    private RestClient restClient;
    private Map<String, Object> configs;

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = new HashMap(configs);
        String authenticationToken = (String)configs.get("authenticationToken");
        if (authenticationToken.isEmpty()) {
            throw new ConfigException(String.format("Missing required configuration %s which has no default value.", "authenticationToken"));
        }
        this.createRestClient(this.configs, authenticationToken);
    }

    private void createRestClient(Map<String, Object> configs, String authenticationToken) {
        this.closeRestClient();
        configs.put("confluent.metadata.http.auth.credentials.provider", BuiltInAuthProviders.HttpCredentialProviders.BEARER.name());
        configs.put("confluent.metadata.token.auth.credential", authenticationToken);
        this.restClient = new RestClient(configs);
    }

    @Override
    void attachAuthToken(OAuthBearerTokenCallback callback) {
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had an Authentication Token already");
        }
        JwtBearerToken token = this.restClient.login();
        this.createRestClient(this.configs, token.value());
        callback.token((OAuthBearerToken)token);
    }

    @Override
    public void close() {
        this.closeRestClient();
    }

    private void closeRestClient() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }
}

