/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.utils.VerifiableProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaAvroSerializer
extends AbstractKafkaSchemaSerDe {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    protected boolean autoRegisterSchema;

    protected void configure(KafkaAvroSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new AvroSchemaProvider());
        this.autoRegisterSchema = config.autoRegisterSchema();
    }

    protected KafkaAvroSerializerConfig serializerConfig(Map<String, ?> props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected KafkaAvroSerializerConfig serializerConfig(VerifiableProperties props) {
        return new KafkaAvroSerializerConfig(props.props());
    }

    protected byte[] serializeImpl(String subject, Object object) throws SerializationException {
        Schema schema = null;
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            schema = AvroSchemaUtils.getSchema((Object)object, (boolean)this.useSchemaReflection);
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering Avro schema: ";
                id = this.schemaRegistry.register(subject, (ParsedSchema)new AvroSchema(schema));
            } else {
                restClientErrorMsg = "Error retrieving Avro schema: ";
                id = this.schemaRegistry.getId(subject, (ParsedSchema)new AvroSchema(schema));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            if (object instanceof byte[]) {
                out.write((byte[])object);
            } else {
                Object value;
                BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
                Object object2 = value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
                Object writer = value instanceof SpecificRecord ? new SpecificDatumWriter(schema) : (this.useSchemaReflection ? new ReflectDatumWriter(schema) : new GenericDatumWriter(schema));
                writer.write(value, (Encoder)encoder);
                encoder.flush();
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Avro message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw new SerializationException(restClientErrorMsg + schema, (Throwable)e);
        }
    }
}

