/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.metrics;

import io.confluent.common.metrics.KafkaMetric;
import io.confluent.common.metrics.Measurable;
import io.confluent.common.metrics.MetricConfig;
import io.confluent.common.metrics.MetricName;
import io.confluent.common.metrics.MetricsReporter;
import io.confluent.common.metrics.Sensor;
import io.confluent.common.utils.CopyOnWriteMap;
import io.confluent.common.utils.SystemTime;
import io.confluent.common.utils.Time;
import io.confluent.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class Metrics {
    private final MetricConfig config;
    private final ConcurrentMap<MetricName, KafkaMetric> metrics;
    private final ConcurrentMap<String, Sensor> sensors;
    private final List<MetricsReporter> reporters;
    private final Time time;

    public Metrics() {
        this(new MetricConfig());
    }

    public Metrics(Time time) {
        this(new MetricConfig(), new ArrayList<MetricsReporter>(0), time);
    }

    public Metrics(MetricConfig defaultConfig) {
        this(defaultConfig, new ArrayList<MetricsReporter>(0), (Time)new SystemTime());
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time) {
        this.config = defaultConfig;
        this.sensors = new CopyOnWriteMap();
        this.metrics = new CopyOnWriteMap();
        this.reporters = (List)Utils.notNull(reporters);
        this.time = time;
        for (MetricsReporter reporter : reporters) {
            reporter.init(new ArrayList<KafkaMetric>());
        }
    }

    public Sensor getSensor(String name) {
        return (Sensor)this.sensors.get(Utils.notNull((Object)name));
    }

    public Sensor sensor(String name) {
        return this.sensor(name, (MetricConfig)null, (Sensor[])null);
    }

    public Sensor sensor(String name, Sensor ... parents) {
        return this.sensor(name, (MetricConfig)null, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, Sensor ... parents) {
        Sensor s = this.getSensor(name);
        if (s == null) {
            s = new Sensor(this, name, parents, config == null ? this.config : config, this.time);
            this.sensors.put(name, s);
        }
        return s;
    }

    public void addMetric(MetricName metricName, Measurable measurable) {
        this.addMetric(metricName, null, measurable);
    }

    public synchronized void addMetric(MetricName metricName, MetricConfig config, Measurable measurable) {
        KafkaMetric m = new KafkaMetric(new Object(), (MetricName)Utils.notNull((Object)metricName), (Measurable)Utils.notNull((Object)measurable), config == null ? this.config : config, this.time);
        this.registerMetric(m);
    }

    public synchronized void addReporter(MetricsReporter reporter) {
        ((MetricsReporter)Utils.notNull((Object)reporter)).init(new ArrayList<KafkaMetric>(this.metrics.values()));
        this.reporters.add(reporter);
    }

    synchronized void registerMetric(KafkaMetric metric) {
        MetricName metricName = metric.metricName();
        if (this.metrics.containsKey(metricName)) {
            throw new IllegalArgumentException("A metric named '" + metricName + "' already exists, can't register another one.");
        }
        this.metrics.put(metricName, metric);
        for (MetricsReporter reporter : this.reporters) {
            reporter.metricChange(metric);
        }
    }

    public Map<MetricName, KafkaMetric> metrics() {
        return this.metrics;
    }

    public void close() {
        for (MetricsReporter reporter : this.reporters) {
            reporter.close();
        }
    }
}

