/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.provider;

import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.RequestContext;
import io.confluent.security.authorizer.Scope;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.common.utils.Lazy;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuthorizationEvent;
import org.apache.kafka.server.authorizer.AuthorizationResult;

public class ConfluentAuthorizationEvent
implements AuthorizationEvent {
    private final Instant timestamp;
    private final Scope sourceScope;
    private final RequestContext requestContext;
    private final Action action;
    private final AuthorizeResult authorizeResult;
    private final AuthorizePolicy authorizePolicy;
    private final Lazy<UUID> lazyUUID;
    private Map<String, Object> data = Collections.emptyMap();

    public ConfluentAuthorizationEvent(Scope sourceScope, RequestContext requestContext, Action action, AuthorizeResult authorizationResult, AuthorizePolicy authorizePolicy, Instant timestamp) {
        this.sourceScope = sourceScope;
        this.requestContext = requestContext;
        this.action = action;
        this.authorizeResult = authorizationResult;
        this.authorizePolicy = authorizePolicy;
        this.timestamp = timestamp;
        this.lazyUUID = new Lazy();
    }

    public ConfluentAuthorizationEvent(Scope sourceScope, RequestContext requestContext, Action action, AuthorizeResult authorizationResult, AuthorizePolicy authorizePolicy) {
        this(sourceScope, requestContext, action, authorizationResult, authorizePolicy, Instant.now());
    }

    public Scope sourceScope() {
        return this.sourceScope;
    }

    public RequestContext requestContext() {
        return this.requestContext;
    }

    public Action action() {
        return this.action;
    }

    public AuthorizeResult authorizeResult() {
        return this.authorizeResult;
    }

    public AuthorizePolicy authorizePolicy() {
        return this.authorizePolicy;
    }

    public UUID uuid() {
        return (UUID)this.lazyUUID.getOrCompute(UUID::randomUUID);
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public AuditEventType type() {
        return AuditEventType.AUTHORIZATION;
    }

    public AuditEventStatus status() {
        if (this.authorizeResult == AuthorizeResult.ALLOWED) {
            return AuditEventStatus.SUCCESS;
        }
        return AuditEventStatus.FAILURE;
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public org.apache.kafka.server.authorizer.Action authorizeAction() {
        return this.action().toKafkaAction();
    }

    public AuthorizationResult authorizationResult() {
        if (this.authorizeResult == AuthorizeResult.ALLOWED) {
            return AuthorizationResult.ALLOWED;
        }
        return AuthorizationResult.DENIED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluentAuthorizationEvent that = (ConfluentAuthorizationEvent)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.sourceScope, that.sourceScope) && Objects.equals(this.requestContext, that.requestContext) && Objects.equals(this.action, that.action) && this.authorizeResult == that.authorizeResult && Objects.equals(this.authorizePolicy, that.authorizePolicy) && Objects.equals(this.lazyUUID, that.lazyUUID) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.sourceScope, this.requestContext, this.action, this.authorizeResult, this.authorizePolicy, this.lazyUUID, this.data});
    }

    public String toString() {
        return "ConfluentAuthorizationEvent{timestamp=" + this.timestamp + ", sourceScope=" + this.sourceScope + ", requestContext=" + this.requestContext + ", action=" + this.action + ", authorizeResult=" + (Object)((Object)this.authorizeResult) + ", authorizePolicy=" + this.authorizePolicy + ", lazyUUID=" + this.lazyUUID + ", data=" + this.data + '}';
    }
}

