/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.provider;

import io.confluent.security.authorizer.AccessRule;
import java.util.Optional;

public class AuthorizeRule {
    private Optional<AccessRule> denyRule = Optional.empty();
    private Optional<AccessRule> allowRule = Optional.empty();
    private boolean noResourceAcls = true;

    public Optional<AccessRule> denyRule() {
        return this.denyRule;
    }

    public Optional<AccessRule> allowRule() {
        return this.allowRule;
    }

    public boolean noResourceAcls() {
        return this.noResourceAcls;
    }

    public void addRuleIfNotExist(AccessRule rule) {
        this.noResourceAcls = false;
        if (!this.denyRule.isPresent()) {
            switch (rule.permissionType()) {
                case DENY: {
                    this.denyRule = Optional.of(rule);
                    break;
                }
                case ALLOW: {
                    if (this.allowRule.isPresent()) break;
                    this.allowRule = Optional.of(rule);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported access rule permission type " + (Object)((Object)rule.permissionType()));
                }
            }
        }
    }

    public void add(AuthorizeRule other) {
        if (!this.denyRule.isPresent()) {
            other.denyRule.ifPresent(this::addRuleIfNotExist);
            other.allowRule.ifPresent(this::addRuleIfNotExist);
        }
        if (!other.noResourceAcls) {
            this.noResourceAcls = false;
        }
    }

    public void noResourceAcls(boolean noResourceAcls) {
        this.noResourceAcls = noResourceAcls;
    }

    public boolean deny() {
        return this.denyRule.isPresent();
    }

    public String toString() {
        return "AuthorizeRule{denyRule=" + this.denyRule + ", allowRule=" + this.allowRule + ", noResourceAcls=" + this.noResourceAcls + '}';
    }
}

