/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.PermissionType;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.Objects;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class AclAccessRule
extends AccessRule {
    private final AclBinding aclBinding;

    public AclAccessRule(ResourcePattern resourcePattern, KafkaPrincipal principal, PermissionType permissionType, String host, Operation operation, AuthorizePolicy.PolicyType policyType, AclBinding aclBinding) {
        super(resourcePattern, principal, permissionType, host, operation, policyType);
        this.aclBinding = Objects.requireNonNull(aclBinding);
    }

    public AclBinding aclBinding() {
        return this.aclBinding;
    }

    @Override
    public String toString() {
        return String.format("%s has %s permission for operation %s on %s from host %s (source: %s: %s)", new Object[]{this.principal(), this.permissionType(), this.operation(), this.resourcePattern(), this.host(), this.policyType(), this.aclBinding});
    }
}

