/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.http.HttpMessageFactory;
import io.cloudevents.http.impl.HttpMessageWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.http.HttpHeaders;

public class CloudEventHttpUtils {
    private CloudEventHttpUtils() {
    }

    public static MessageReader toReader(HttpHeaders headers, Supplier<byte[]> body) throws CloudEventRWException {
        return HttpMessageFactory.createReaderFromMultimap((Map)headers, (byte[])body.get());
    }

    public static HttpMessageWriter toWriter(HttpHeaders headers, Consumer<byte[]> sendBody) {
        return HttpMessageFactory.createWriter((arg_0, arg_1) -> ((HttpHeaders)headers).set(arg_0, arg_1), sendBody);
    }

    public static HttpHeaders toHttp(CloudEventContext event) throws CloudEventRWException {
        HttpHeaders headers = new HttpHeaders();
        CloudEventUtils.toReader((CloudEvent)CloudEventBuilder.fromContext((CloudEventContext)event).build()).read((CloudEventWriterFactory)CloudEventHttpUtils.toWriter(headers, bytes -> {}));
        return headers;
    }

    public static CloudEventBuilder fromHttp(HttpHeaders headers) throws CloudEventRWException {
        return CloudEventBuilder.fromContext((CloudEventContext)CloudEventUtils.toEvent((CloudEventReader)CloudEventHttpUtils.toReader(headers, () -> null)));
    }
}

