/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.messaging;

import io.cloudevents.CloudEventContext;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.spring.messaging.MessageBinaryMessageReader;
import io.cloudevents.spring.messaging.MessageBuilderMessageWriter;
import java.util.HashMap;
import java.util.Map;

public class CloudEventContextUtils {
    public static CloudEventContext fromMap(Map<String, Object> headers) throws CloudEventRWException {
        Object value = headers.get("ce-specversion");
        SpecVersion version = value == null ? SpecVersion.V1 : SpecVersion.parse((String)value.toString());
        return CloudEventUtils.toEvent((CloudEventReader)new MessageBinaryMessageReader(version, headers));
    }

    public static Map<String, Object> toMap(CloudEventContext context) throws CloudEventRWException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("ce-specversion", context.getSpecVersion().toString());
        MessageBuilderMessageWriter writer = new MessageBuilderMessageWriter(headers);
        CloudEventUtils.toContextReader((CloudEventContext)context).readContext((CloudEventContextWriter)writer);
        return writer.end().getHeaders();
    }
}

