/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.webflux;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import io.cloudevents.spring.http.CloudEventsHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import reactor.core.publisher.Mono;

public class CloudEventHttpMessageWriter
implements HttpMessageWriter<CloudEvent> {
    public List<MediaType> getWritableMediaTypes() {
        return Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL);
    }

    public boolean canWrite(ResolvableType elementType, MediaType mediaType) {
        return CloudEvent.class.isAssignableFrom(elementType.toClass());
    }

    public Mono<Void> write(Publisher<? extends CloudEvent> inputStream, ResolvableType elementType, MediaType mediaType, ReactiveHttpOutputMessage message, Map<String, Object> hints) {
        return Mono.from(inputStream).map(CloudEventUtils::toReader).flatMap(reader -> (Mono)reader.read((CloudEventWriterFactory)new ReactiveHttpMessageWriter(message)));
    }

    private static class ReactiveHttpMessageWriter
    implements MessageWriter<CloudEventWriter<Mono<Void>>, Mono<Void>>,
    CloudEventWriter<Mono<Void>> {
        private final ReactiveHttpOutputMessage response;

        public ReactiveHttpMessageWriter(ReactiveHttpOutputMessage response) {
            this.response = response;
        }

        public CloudEventWriter<Mono<Void>> create(SpecVersion version) {
            this.response.getHeaders().set(CloudEventsHeaders.SPEC_VERSION, version.toString());
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
            String headerName = CloudEventsHeaders.ATTRIBUTES_TO_HEADERS.get(name);
            if (headerName == null) {
                headerName = "ce-" + name;
            }
            this.response.getHeaders().set(headerName, value);
            return this;
        }

        public Mono<Void> end(CloudEventData value) throws CloudEventRWException {
            return this.copy(value.toBytes(), this.response);
        }

        public Mono<Void> end() {
            return this.copy(new byte[0], this.response);
        }

        public Mono<Void> setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
            this.response.getHeaders().set("Content-Type", format.serializedContentType());
            return this.copy(value, this.response);
        }

        private Mono<Void> copy(byte[] bytes, ReactiveHttpOutputMessage message) {
            DataBuffer data = message.bufferFactory().wrap(bytes);
            message.getHeaders().setContentLength((long)bytes.length);
            return message.writeWith((Publisher)Mono.just((Object)data));
        }
    }
}

