/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.messaging;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.core.message.impl.MessageUtils;
import io.cloudevents.rw.CloudEventWriterFactory;
import io.cloudevents.spring.messaging.MessageBinaryMessageReader;
import io.cloudevents.spring.messaging.MessageBuilderMessageWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;

public class CloudEventMessageConverter
implements MessageConverter {
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        if (CloudEvent.class.isAssignableFrom(targetClass)) {
            return this.createMessageReader(message).toEvent();
        }
        return null;
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        if (payload instanceof CloudEvent) {
            CloudEvent event = (CloudEvent)payload;
            return (Message)CloudEventUtils.toReader((CloudEvent)event).read((CloudEventWriterFactory)new MessageBuilderMessageWriter((Map<String, Object>)headers));
        }
        return null;
    }

    private MessageReader createMessageReader(Message<?> message) {
        return MessageUtils.parseStructuredOrBinaryMessage(() -> this.contentType(message.getHeaders()), format -> this.structuredMessageReader(message, (EventFormat)format), () -> this.version(message.getHeaders()), version -> this.binaryMessageReader(message, (SpecVersion)version));
    }

    private String version(MessageHeaders message) {
        if (message.containsKey((Object)"ce-specversion")) {
            return message.get((Object)"ce-specversion").toString();
        }
        return null;
    }

    private MessageReader binaryMessageReader(Message<?> message, SpecVersion version) {
        return new MessageBinaryMessageReader(version, (Map<String, Object>)message.getHeaders(), this.getBinaryData(message));
    }

    private MessageReader structuredMessageReader(Message<?> message, EventFormat format) {
        return new GenericStructuredMessageReader(format, this.getBinaryData(message));
    }

    private String contentType(MessageHeaders message) {
        if (message.containsKey((Object)"contentType")) {
            return message.get((Object)"contentType").toString();
        }
        if (message.containsKey((Object)"ce-datacontenttype")) {
            return message.get((Object)"ce-datacontenttype").toString();
        }
        return null;
    }

    private byte[] getBinaryData(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof byte[]) {
            return (byte[])payload;
        }
        if (payload instanceof String) {
            return ((String)payload).getBytes(Charset.defaultCharset());
        }
        return null;
    }
}

