/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEventContext;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.time.OffsetDateTime;

public class CloudEventContextReaderAdapter
implements CloudEventContextReader {
    private final CloudEventContext event;

    public CloudEventContextReaderAdapter(CloudEventContext event) {
        this.event = event;
    }

    public void readAttributes(CloudEventContextWriter writer) throws RuntimeException {
        writer.withContextAttribute("id", this.event.getId());
        writer.withContextAttribute("source", this.event.getSource());
        writer.withContextAttribute("type", this.event.getType());
        if (this.event.getDataContentType() != null) {
            writer.withContextAttribute("datacontenttype", this.event.getDataContentType());
        }
        if (this.event.getDataSchema() != null) {
            writer.withContextAttribute("dataschema", this.event.getDataSchema());
        }
        if (this.event.getSubject() != null) {
            writer.withContextAttribute("subject", this.event.getSubject());
        }
        if (this.event.getTime() != null) {
            writer.withContextAttribute("time", this.event.getTime());
        }
    }

    public void readExtensions(CloudEventContextWriter writer) throws RuntimeException {
        for (String key : this.event.getExtensionNames()) {
            Object value = this.event.getExtension(key);
            if (value instanceof String) {
                writer.withContextAttribute(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                writer.withContextAttribute(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                writer.withContextAttribute(key, (Boolean)value);
                continue;
            }
            if (value instanceof URI) {
                writer.withContextAttribute(key, (URI)value);
                continue;
            }
            if (value instanceof OffsetDateTime) {
                writer.withContextAttribute(key, (OffsetDateTime)value);
                continue;
            }
            throw new IllegalStateException("Illegal value inside extensions map: " + key + " " + value);
        }
    }

    public void readContext(CloudEventContextWriter writer) throws CloudEventRWException {
        this.readAttributes(writer);
        this.readExtensions(writer);
    }
}

