/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v1;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import io.cloudevents.core.provider.CloudEventValidatorProvider;
import io.cloudevents.core.v1.CloudEventV1;
import io.cloudevents.core.v1.V03ToV1AttributesConverter;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.types.Time;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;

public final class CloudEventBuilder
extends BaseCloudEventBuilder<CloudEventBuilder, CloudEventV1> {
    private String id;
    private URI source;
    private String type;
    private String datacontenttype;
    private URI dataschema;
    private String subject;
    private OffsetDateTime time;

    public CloudEventBuilder() {
    }

    public CloudEventBuilder(CloudEvent event) {
        super(event);
    }

    public CloudEventBuilder(CloudEventContext context) {
        super(context);
    }

    @Override
    protected void setAttributes(CloudEventContext event) {
        CloudEventContextReader contextReader = CloudEventUtils.toContextReader(event);
        if (event.getSpecVersion() == SpecVersion.V1) {
            contextReader.readContext((CloudEventContextWriter)this);
        } else {
            contextReader.readContext((CloudEventContextWriter)new V03ToV1AttributesConverter(this));
        }
    }

    @Override
    public CloudEventBuilder withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public CloudEventBuilder withSource(URI source) {
        this.source = source;
        return this;
    }

    @Override
    public CloudEventBuilder withType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public CloudEventBuilder withDataSchema(URI dataSchema) {
        this.dataschema = dataSchema;
        return this;
    }

    @Override
    public CloudEventBuilder withDataContentType(String dataContentType) {
        this.datacontenttype = dataContentType;
        return this;
    }

    @Override
    public CloudEventBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public CloudEventBuilder withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Override
    public CloudEvent build() {
        if (this.id == null) {
            throw CloudEventBuilder.createMissingAttributeException("id");
        }
        if (this.source == null) {
            throw CloudEventBuilder.createMissingAttributeException("source");
        }
        if (this.type == null) {
            throw CloudEventBuilder.createMissingAttributeException("type");
        }
        CloudEventV1 cloudEvent = new CloudEventV1(this.id, this.source, this.type, this.datacontenttype, this.dataschema, this.subject, this.time, this.data, this.extensions);
        CloudEventValidatorProvider validator = CloudEventValidatorProvider.getInstance();
        validator.validate(cloudEvent);
        return cloudEvent;
    }

    @Override
    public CloudEventBuilder newBuilder() {
        CloudEventBuilder newBuilder = new CloudEventBuilder();
        newBuilder.id = this.id;
        newBuilder.source = this.source;
        newBuilder.type = this.type;
        newBuilder.time = this.time;
        newBuilder.dataschema = this.dataschema;
        newBuilder.datacontenttype = this.datacontenttype;
        newBuilder.subject = this.subject;
        newBuilder.data = this.data;
        newBuilder.extensions.putAll(this.extensions);
        return newBuilder;
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        this.requireValidAttributeWrite(name);
        switch (name) {
            case "id": {
                this.withId(value);
                return this;
            }
            case "source": {
                try {
                    this.withSource(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"source", (Object)value, (Throwable)e);
                }
                return this;
            }
            case "type": {
                this.withType(value);
                return this;
            }
            case "datacontenttype": {
                this.withDataContentType(value);
                return this;
            }
            case "dataschema": {
                try {
                    this.withDataSchema(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"dataschema", (Object)value, (Throwable)e);
                }
                return this;
            }
            case "subject": {
                this.withSubject(value);
                return this;
            }
            case "time": {
                this.withTime(Time.parseTime((String)"time", (String)value));
                return this;
            }
        }
        this.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, URI value) throws CloudEventRWException {
        this.requireValidAttributeWrite(name);
        switch (name) {
            case "source": {
                this.withSource(value);
                return this;
            }
            case "dataschema": {
                this.withDataSchema(value);
                return this;
            }
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "time": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, URI.class);
            }
        }
        this.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
        this.requireValidAttributeWrite(name);
        switch (name) {
            case "time": {
                this.withTime(value);
                return this;
            }
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "source": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, OffsetDateTime.class);
            }
        }
        this.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, Number value) throws CloudEventRWException {
        this.requireValidAttributeWrite(name);
        switch (name) {
            case "time": 
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "source": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, Number.class);
            }
        }
        this.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, Integer value) throws CloudEventRWException {
        this.requireValidAttributeWrite(name);
        switch (name) {
            case "time": 
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "source": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, Integer.class);
            }
        }
        this.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, Boolean value) throws CloudEventRWException {
        this.requireValidAttributeWrite(name);
        switch (name) {
            case "time": 
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "source": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, Boolean.class);
            }
        }
        this.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, byte[] value) throws CloudEventRWException {
        this.requireValidAttributeWrite(name);
        switch (name) {
            case "time": 
            case "dataschema": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "source": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, byte[].class);
            }
        }
        this.withExtension(name, value);
        return this;
    }
}

