/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.avro.compact;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.format.EventSerializationException;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.v1.avro.compact.CloudEvent;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;

public class AvroCompactFormat
implements EventFormat {
    public static final String AVRO_COMPACT_CONTENT_TYPE = "application/cloudevents+avrocompact";

    public byte[] serialize(CloudEvent from) throws EventSerializationException {
        try {
            CloudEventData data;
            CloudEvent.Builder to = io.cloudevents.v1.avro.compact.CloudEvent.newBuilder();
            HashMap<String, Object> extensions = new HashMap<String, Object>();
            for (String name : from.getExtensionNames()) {
                Object value = from.getExtension(name);
                if (value instanceof byte[]) {
                    value = ByteBuffer.wrap((byte[])value);
                } else if (value instanceof OffsetDateTime) {
                    value = ((OffsetDateTime)value).toInstant();
                }
                extensions.put(name, value);
            }
            to.setSource(from.getSource().toString()).setType(from.getType()).setId(from.getId()).setSubject(from.getSubject()).setDatacontenttype(from.getDataContentType()).setExtensions(extensions);
            if (from.getTime() != null) {
                to.setTime(from.getTime().toInstant());
            }
            if (from.getDataSchema() != null) {
                to.setDataschema(from.getDataSchema().toString());
            }
            if ((data = from.getData()) != null) {
                to.setData(ByteBuffer.wrap(data.toBytes()));
            }
            return to.build().toByteBuffer().array();
        }
        catch (Exception e) {
            throw new EventSerializationException((Throwable)e);
        }
    }

    public CloudEvent deserialize(byte[] bytes, CloudEventDataMapper<? extends CloudEventData> mapper) throws EventDeserializationException {
        try {
            io.cloudevents.v1.avro.compact.CloudEvent from = io.cloudevents.v1.avro.compact.CloudEvent.fromByteBuffer(ByteBuffer.wrap(bytes));
            io.cloudevents.core.v1.CloudEventBuilder to = CloudEventBuilder.v1().withSource(URI.create(from.getSource())).withType(from.getType()).withId(from.getType()).withSubject(from.getSubject()).withDataContentType(from.getDatacontenttype());
            if (from.getTime() != null) {
                to.withTime(from.getTime().atOffset(ZoneOffset.UTC));
            }
            if (from.getDataschema() != null) {
                to.withDataSchema(URI.create(from.getDataschema()));
            }
            for (Map.Entry<String, Object> entry : from.getExtensions().entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Boolean) {
                    to.withExtension(name, Boolean.valueOf((Boolean)value));
                    continue;
                }
                if (value instanceof Integer) {
                    to.withExtension(name, (Number)((Integer)value));
                    continue;
                }
                if (value instanceof Instant) {
                    to.withExtension(name, ((Instant)value).atOffset(ZoneOffset.UTC));
                    continue;
                }
                if (value instanceof String) {
                    to.withExtension(name, (String)value);
                    continue;
                }
                if (value instanceof ByteBuffer) {
                    to.withExtension(name, ((ByteBuffer)value).array());
                    continue;
                }
                throw new AssertionError((Object)String.format("invalid extension %s unsupported type %s", name, value.getClass()));
            }
            if (from.getData() == null) {
                return (CloudEvent)to.end();
            }
            BytesCloudEventData data = BytesCloudEventData.wrap((byte[])from.getData().array());
            return (CloudEvent)to.end(mapper.map((CloudEventData)data));
        }
        catch (Exception e) {
            throw new EventDeserializationException((Throwable)e);
        }
    }

    public String serializedContentType() {
        return AVRO_COMPACT_CONTENT_TYPE;
    }
}

