/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.UsageMetricsResponseItem;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"activeTenants", "tenants", "processInstances", "decisionInstances", "assignees"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UsageMetricsResponse {
    public static final String JSON_PROPERTY_ACTIVE_TENANTS = "activeTenants";
    @Nullable
    private Long activeTenants;
    public static final String JSON_PROPERTY_TENANTS = "tenants";
    @Nullable
    private Map<String, UsageMetricsResponseItem> tenants = new HashMap<String, UsageMetricsResponseItem>();
    public static final String JSON_PROPERTY_PROCESS_INSTANCES = "processInstances";
    @Nullable
    private Long processInstances;
    public static final String JSON_PROPERTY_DECISION_INSTANCES = "decisionInstances";
    @Nullable
    private Long decisionInstances;
    public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
    @Nullable
    private Long assignees;

    public UsageMetricsResponse activeTenants(@Nullable Long activeTenants) {
        this.activeTenants = activeTenants;
        return this;
    }

    @Nullable
    @JsonProperty(value="activeTenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getActiveTenants() {
        return this.activeTenants;
    }

    @JsonProperty(value="activeTenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActiveTenants(@Nullable Long activeTenants) {
        this.activeTenants = activeTenants;
    }

    public UsageMetricsResponse tenants(@Nullable Map<String, UsageMetricsResponseItem> tenants) {
        this.tenants = tenants;
        return this;
    }

    public UsageMetricsResponse putTenantsItem(String key, UsageMetricsResponseItem tenantsItem) {
        if (this.tenants == null) {
            this.tenants = new HashMap<String, UsageMetricsResponseItem>();
        }
        this.tenants.put(key, tenantsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, UsageMetricsResponseItem> getTenants() {
        return this.tenants;
    }

    @JsonProperty(value="tenants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenants(@Nullable Map<String, UsageMetricsResponseItem> tenants) {
        this.tenants = tenants;
    }

    public UsageMetricsResponse processInstances(@Nullable Long processInstances) {
        this.processInstances = processInstances;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getProcessInstances() {
        return this.processInstances;
    }

    @JsonProperty(value="processInstances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstances(@Nullable Long processInstances) {
        this.processInstances = processInstances;
    }

    public UsageMetricsResponse decisionInstances(@Nullable Long decisionInstances) {
        this.decisionInstances = decisionInstances;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionInstances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDecisionInstances() {
        return this.decisionInstances;
    }

    @JsonProperty(value="decisionInstances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionInstances(@Nullable Long decisionInstances) {
        this.decisionInstances = decisionInstances;
    }

    public UsageMetricsResponse assignees(@Nullable Long assignees) {
        this.assignees = assignees;
        return this;
    }

    @Nullable
    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignees(@Nullable Long assignees) {
        this.assignees = assignees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageMetricsResponse usageMetricsResponse = (UsageMetricsResponse)o;
        return Objects.equals(this.activeTenants, usageMetricsResponse.activeTenants) && Objects.equals(this.tenants, usageMetricsResponse.tenants) && Objects.equals(this.processInstances, usageMetricsResponse.processInstances) && Objects.equals(this.decisionInstances, usageMetricsResponse.decisionInstances) && Objects.equals(this.assignees, usageMetricsResponse.assignees);
    }

    public int hashCode() {
        return Objects.hash(this.activeTenants, this.tenants, this.processInstances, this.decisionInstances, this.assignees);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageMetricsResponse {\n");
        sb.append("    activeTenants: ").append(this.toIndentedString(this.activeTenants)).append("\n");
        sb.append("    tenants: ").append(this.toIndentedString(this.tenants)).append("\n");
        sb.append("    processInstances: ").append(this.toIndentedString(this.processInstances)).append("\n");
        sb.append("    decisionInstances: ").append(this.toIndentedString(this.decisionInstances)).append("\n");
        sb.append("    assignees: ").append(this.toIndentedString(this.assignees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getProcessInstances() != null) {
            try {
                joiner.add(String.format("%sprocessInstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessInstances()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDecisionInstances() != null) {
            try {
                joiner.add(String.format("%sdecisionInstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDecisionInstances()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAssignees() != null) {
            try {
                joiner.add(String.format("%sassignees%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssignees()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

