/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"field", "order"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchQuerySortRequest {
    public static final String JSON_PROPERTY_FIELD = "field";
    private String field;
    public static final String JSON_PROPERTY_ORDER = "order";
    private String order = "asc";

    public SearchQuerySortRequest field(String field) {
        this.field = field;
        return this;
    }

    @Nonnull
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setField(String field) {
        this.field = field;
    }

    public SearchQuerySortRequest order(String order) {
        this.order = order;
        return this;
    }

    @Nullable
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(String order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQuerySortRequest searchQuerySortRequest = (SearchQuerySortRequest)o;
        return Objects.equals(this.field, searchQuerySortRequest.field) && Objects.equals(this.order, searchQuerySortRequest.order);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.order);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchQuerySortRequest {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getField() != null) {
            try {
                joiner.add(String.format("%sfield%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getField()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOrder() != null) {
            try {
                joiner.add(String.format("%sorder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOrder()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

