/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"permissionType", "resourceIds"})
@JsonTypeName(value="AuthorizationPatchRequest_permissions_inner")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthorizationPatchRequestPermissionsInner {
    public static final String JSON_PROPERTY_PERMISSION_TYPE = "permissionType";
    private PermissionTypeEnum permissionType;
    public static final String JSON_PROPERTY_RESOURCE_IDS = "resourceIds";
    private List<String> resourceIds = new ArrayList<String>();

    public AuthorizationPatchRequestPermissionsInner permissionType(PermissionTypeEnum permissionType) {
        this.permissionType = permissionType;
        return this;
    }

    @Nullable
    @JsonProperty(value="permissionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionTypeEnum getPermissionType() {
        return this.permissionType;
    }

    @JsonProperty(value="permissionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissionType(PermissionTypeEnum permissionType) {
        this.permissionType = permissionType;
    }

    public AuthorizationPatchRequestPermissionsInner resourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public AuthorizationPatchRequestPermissionsInner addResourceIdsItem(String resourceIdsItem) {
        if (this.resourceIds == null) {
            this.resourceIds = new ArrayList<String>();
        }
        this.resourceIds.add(resourceIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    @JsonProperty(value="resourceIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationPatchRequestPermissionsInner authorizationPatchRequestPermissionsInner = (AuthorizationPatchRequestPermissionsInner)o;
        return Objects.equals((Object)this.permissionType, (Object)authorizationPatchRequestPermissionsInner.permissionType) && Objects.equals(this.resourceIds, authorizationPatchRequestPermissionsInner.resourceIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.permissionType, this.resourceIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationPatchRequestPermissionsInner {\n");
        sb.append("    permissionType: ").append(this.toIndentedString((Object)this.permissionType)).append("\n");
        sb.append("    resourceIds: ").append(this.toIndentedString(this.resourceIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPermissionType() != null) {
            try {
                joiner.add(String.format("%spermissionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getPermissionType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceIds() != null) {
            for (int i = 0; i < this.getResourceIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sresourceIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getResourceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum PermissionTypeEnum {
        CREATE("CREATE"),
        READ("READ"),
        UPDATE("UPDATE"),
        DELETE("DELETE"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PermissionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionTypeEnum fromValue(String value) {
            for (PermissionTypeEnum b : PermissionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

