/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.IncidentFilter;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.query.IncidentQuery;
import io.camunda.zeebe.client.api.search.response.Incident;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.sort.IncidentSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchRequestPageImpl;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.protocol.rest.IncidentFilterRequest;
import io.camunda.zeebe.client.protocol.rest.IncidentSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.IncidentSearchQueryResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class IncidentQueryImpl
extends TypedSearchRequestPropertyProvider<IncidentSearchQueryRequest>
implements IncidentQuery {
    private final IncidentSearchQueryRequest request = new IncidentSearchQueryRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public IncidentQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<Incident> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SearchQueryResponse<Incident>> send() {
        HttpZeebeFuture<SearchQueryResponse<Incident>> result = new HttpZeebeFuture<SearchQueryResponse<Incident>>();
        this.httpClient.post("/incidents/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), IncidentSearchQueryResponse.class, SearchResponseMapper::toIncidentSearchResponse, result);
        return result;
    }

    @Override
    public IncidentQuery filter(IncidentFilter value) {
        IncidentFilterRequest filter = (IncidentFilterRequest)IncidentQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public IncidentQuery filter(Consumer<IncidentFilter> fn) {
        return this.filter(SearchRequestBuilders.incidentFilter(fn));
    }

    @Override
    public IncidentQuery sort(IncidentSort value) {
        List sorting = (List)IncidentQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(sorting);
        return this;
    }

    @Override
    public IncidentQuery sort(Consumer<IncidentSort> fn) {
        return this.sort(SearchRequestBuilders.incidentSort(fn));
    }

    @Override
    public IncidentQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public IncidentQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected IncidentSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

