/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ProcessInstanceResult;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.CreateProcessInstanceWithResultResponseImpl;
import io.camunda.zeebe.client.protocol.rest.CreateProcessInstanceRequest;
import io.camunda.zeebe.client.protocol.rest.CreateProcessInstanceResponse;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CreateProcessInstanceWithResultCommandImpl
implements CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 {
    private static final Duration DEADLINE_OFFSET = Duration.ofSeconds(10L);
    private final JsonMapper jsonMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CreateProcessInstanceRequest.Builder createProcessInstanceRequestBuilder;
    private final GatewayOuterClass.CreateProcessInstanceWithResultRequest.Builder grpcRequestObject;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final boolean useRest;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final CreateProcessInstanceRequest httpRequestObject;

    public CreateProcessInstanceWithResultCommandImpl(JsonMapper jsonMapper, GatewayGrpc.GatewayStub asyncStub, GatewayOuterClass.CreateProcessInstanceRequest.Builder grpcRequestObject, Predicate<CredentialsProvider.StatusCode> retryPredicate, Duration requestTimeout, HttpClient httpClient, boolean preferRestOverGrpc, CreateProcessInstanceRequest httpRequestObject) {
        this.jsonMapper = jsonMapper;
        this.asyncStub = asyncStub;
        this.createProcessInstanceRequestBuilder = grpcRequestObject;
        this.retryPredicate = retryPredicate;
        this.requestTimeout = requestTimeout;
        this.grpcRequestObject = GatewayOuterClass.CreateProcessInstanceWithResultRequest.newBuilder();
        this.httpRequestObject = httpRequestObject.awaitCompletion(true);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.useRest = preferRestOverGrpc;
        this.requestTimeout(requestTimeout);
    }

    @Override
    public FinalCommandStep<ProcessInstanceResult> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.grpcRequestObject.setRequestTimeout(requestTimeout.toMillis());
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<ProcessInstanceResult> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<ProcessInstanceResult> sendRestRequest() {
        HttpZeebeFuture<ProcessInstanceResult> result = new HttpZeebeFuture<ProcessInstanceResult>();
        this.httpClient.post("/process-instances", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), CreateProcessInstanceResponse.class, response -> new CreateProcessInstanceWithResultResponseImpl(this.jsonMapper, (CreateProcessInstanceResponse)response), result);
        return result;
    }

    private ZeebeFuture<ProcessInstanceResult> sendGrpcRequest() {
        GatewayOuterClass.CreateProcessInstanceWithResultRequest request = this.grpcRequestObject.setRequest(this.createProcessInstanceRequestBuilder).setRequestTimeout(this.requestTimeout.toMillis()).build();
        RetriableClientFutureImpl<ProcessInstanceResult, GatewayOuterClass.CreateProcessInstanceWithResultResponse> future = new RetriableClientFutureImpl<ProcessInstanceResult, GatewayOuterClass.CreateProcessInstanceWithResultResponse>(response -> new CreateProcessInstanceWithResultResponseImpl(this.jsonMapper, (GatewayOuterClass.CreateProcessInstanceWithResultResponse)response), this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.CreateProcessInstanceWithResultRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.plus(DEADLINE_OFFSET).toMillis(), TimeUnit.MILLISECONDS)).createProcessInstanceWithResult(request, future);
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 fetchVariables(List<String> fetchVariables) {
        this.grpcRequestObject.addAllFetchVariables(fetchVariables);
        this.httpRequestObject.setFetchVariables(fetchVariables);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 fetchVariables(String ... fetchVariables) {
        this.grpcRequestObject.addAllFetchVariables(Arrays.asList(fetchVariables));
        this.httpRequestObject.setFetchVariables(Arrays.asList(fetchVariables));
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 tenantId(String tenantId) {
        this.createProcessInstanceRequestBuilder.setTenantId(tenantId);
        this.httpRequestObject.setTenantId(tenantId);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 useRest() {
        return null;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 useGrpc() {
        return null;
    }
}

