/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"instanceId", "processDefinitionId", "processDefinitionName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessInstanceReferenceItem {
    public static final String JSON_PROPERTY_INSTANCE_ID = "instanceId";
    private String instanceId;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private String processDefinitionId;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
    private String processDefinitionName;

    public ProcessInstanceReferenceItem instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    @Nullable
    @JsonProperty(value="instanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInstanceId() {
        return this.instanceId;
    }

    @JsonProperty(value="instanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ProcessInstanceReferenceItem processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ProcessInstanceReferenceItem processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @JsonProperty(value="processDefinitionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceReferenceItem processInstanceReferenceItem = (ProcessInstanceReferenceItem)o;
        return Objects.equals(this.instanceId, processInstanceReferenceItem.instanceId) && Objects.equals(this.processDefinitionId, processInstanceReferenceItem.processDefinitionId) && Objects.equals(this.processDefinitionName, processInstanceReferenceItem.processDefinitionName);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.processDefinitionId, this.processDefinitionName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceReferenceItem {\n");
        sb.append("    instanceId: ").append(this.toIndentedString(this.instanceId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInstanceId() != null) {
            try {
                joiner.add(String.format("%sinstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessDefinitionId() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessDefinitionName() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

