/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.UserTaskFilter;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.query.UserTaskQuery;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.response.UserTask;
import io.camunda.zeebe.client.api.search.sort.UserTaskSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchRequestPageImpl;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.impl.search.sort.UserTaskSortImpl;
import io.camunda.zeebe.client.protocol.rest.SearchQuerySortRequest;
import io.camunda.zeebe.client.protocol.rest.UserTaskFilterRequest;
import io.camunda.zeebe.client.protocol.rest.UserTaskSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.UserTaskSearchQueryResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UserTaskQueryImpl
extends TypedSearchRequestPropertyProvider<UserTaskSearchQueryRequest>
implements UserTaskQuery {
    private final UserTaskSearchQueryRequest request = new UserTaskSearchQueryRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UserTaskQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<UserTask> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public HttpZeebeFuture<SearchQueryResponse<UserTask>> send() {
        HttpZeebeFuture<SearchQueryResponse<UserTask>> result = new HttpZeebeFuture<SearchQueryResponse<UserTask>>();
        this.httpClient.post("/user-tasks/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UserTaskSearchQueryResponse.class, SearchResponseMapper::toUserTaskSearchResponse, result);
        return result;
    }

    @Override
    public UserTaskQuery filter(UserTaskFilter value) {
        UserTaskFilterRequest filter = (UserTaskFilterRequest)UserTaskQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public UserTaskQuery filter(Consumer<UserTaskFilter> fn) {
        return this.filter(SearchRequestBuilders.userTaskFilter(fn));
    }

    @Override
    public UserTaskQuery sort(UserTaskSort value) {
        UserTaskSortImpl sorting = (UserTaskSortImpl)value;
        this.request.setSort((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty());
        return this;
    }

    @Override
    public UserTaskQuery sort(Consumer<UserTaskSort> fn) {
        return this.sort(SearchRequestBuilders.userTaskSort(fn));
    }

    @Override
    public UserTaskQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public UserTaskQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected UserTaskSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

