/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.ClockPinCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.PinClockResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.protocol.rest.ClockPinRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ClockPinCommandImpl
implements ClockPinCommandStep1 {
    private final ClockPinRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ClockPinCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new ClockPinRequest();
    }

    @Override
    public ClockPinCommandStep1 time(long timestamp) {
        ArgumentUtil.ensureNotNegative("timestamp", timestamp);
        this.request.setTimestamp(timestamp);
        return this;
    }

    @Override
    public ClockPinCommandStep1 time(Instant instant) {
        ArgumentUtil.ensureNotNull("instant", instant);
        ArgumentUtil.ensureNotBefore("instant", instant, Instant.EPOCH);
        return this.time(instant.toEpochMilli());
    }

    @Override
    public FinalCommandStep<PinClockResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<PinClockResponse> send() {
        HttpZeebeFuture<PinClockResponse> result = new HttpZeebeFuture<PinClockResponse>();
        this.httpClient.put("/clock", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }
}

