/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.worker;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.command.StreamJobsCommandStep1;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.impl.command.ActivateJobsCommandImpl;
import io.camunda.zeebe.client.impl.command.CompleteJobCommandImpl;
import io.camunda.zeebe.client.impl.command.FailJobCommandImpl;
import io.camunda.zeebe.client.impl.command.StreamJobsCommandImpl;
import io.camunda.zeebe.client.impl.command.ThrowErrorCommandImpl;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import java.util.function.Predicate;

public final class JobClientImpl
implements JobClient {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final HttpClient httpClient;
    private final ZeebeClientConfiguration config;
    private final JsonMapper jsonMapper;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;

    public JobClientImpl(GatewayGrpc.GatewayStub asyncStub, HttpClient httpClient, ZeebeClientConfiguration config, JsonMapper jsonMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        this.asyncStub = asyncStub;
        this.httpClient = httpClient;
        this.config = config;
        this.jsonMapper = jsonMapper;
        this.retryPredicate = retryPredicate;
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return new CompleteJobCommandImpl(this.asyncStub, this.jsonMapper, jobKey, this.config.getDefaultRequestTimeout(), this.retryPredicate, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(ActivatedJob job) {
        return this.newCompleteCommand(job.getKey());
    }

    @Override
    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return new FailJobCommandImpl(this.asyncStub, this.jsonMapper, jobKey, this.config.getDefaultRequestTimeout(), this.retryPredicate, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public FailJobCommandStep1 newFailCommand(ActivatedJob job) {
        return this.newFailCommand(job.getKey());
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(long jobKey) {
        return new ThrowErrorCommandImpl(this.asyncStub, this.jsonMapper, jobKey, this.config.getDefaultRequestTimeout(), this.retryPredicate, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(ActivatedJob job) {
        return this.newThrowErrorCommand(job.getKey());
    }

    @Override
    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return new ActivateJobsCommandImpl(this.asyncStub, this.httpClient, this.config, this.jsonMapper, this.retryPredicate);
    }

    @Override
    public StreamJobsCommandStep1 newStreamJobsCommand() {
        return new StreamJobsCommandImpl(this.asyncStub, this.jsonMapper, this.retryPredicate, this.config);
    }
}

