/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.impl.util.Environment;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BuilderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BuilderUtils.class);

    private BuilderUtils() {
    }

    static void appendProperty(StringBuilder sb, String propertyName, Object value) {
        sb.append(propertyName).append(": ").append(value).append("\n");
    }

    static void applyIfNotNull(Properties properties, String propertyName, Consumer<String> action) {
        String value = BuilderUtils.getProperty(properties, propertyName);
        if (value != null) {
            action.accept(value);
        }
    }

    static String getProperty(Properties properties, String propertyName) {
        if (properties.containsKey(propertyName)) {
            return properties.getProperty(propertyName);
        }
        return null;
    }

    static void applyIfNotNull(String envName, Consumer<String> action) {
        String value = BuilderUtils.getProperty(Environment.system(), envName);
        if (value != null) {
            action.accept(value);
        }
    }

    static String getProperty(Environment environment, String envName) {
        if (environment.isDefined(envName)) {
            return environment.get(envName);
        }
        return null;
    }
}

