/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.CancelProcessInstanceResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.response.CancelProcessInstanceResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class CancelProcessInstanceCommandImpl
implements CancelProcessInstanceCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CancelProcessInstanceRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public CancelProcessInstanceCommandImpl(GatewayGrpc.GatewayStub asyncStub, long processInstanceKey, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.CancelProcessInstanceRequest.newBuilder();
        this.builder.setProcessInstanceKey(processInstanceKey);
    }

    @Override
    public FinalCommandStep<CancelProcessInstanceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<CancelProcessInstanceResponse> send() {
        GatewayOuterClass.CancelProcessInstanceRequest request = this.builder.build();
        RetriableClientFutureImpl<CancelProcessInstanceResponse, GatewayOuterClass.CancelProcessInstanceResponse> future = new RetriableClientFutureImpl<CancelProcessInstanceResponse, GatewayOuterClass.CancelProcessInstanceResponse>(CancelProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.CancelProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).cancelProcessInstance(request, future);
    }
}

