/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import com.google.protobuf.ByteString;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.DeployProcessCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.command.StreamUtil;
import io.camunda.zeebe.client.impl.response.DeploymentEventImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class DeployProcessCommandImpl
implements DeployProcessCommandStep1,
DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 {
    private final GatewayOuterClass.DeployProcessRequest.Builder requestBuilder = GatewayOuterClass.DeployProcessRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public DeployProcessCommandImpl(GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
    }

    @Override
    public DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 addResourceBytes(byte[] resource, String resourceName) {
        this.requestBuilder.addProcesses(GatewayOuterClass.ProcessRequestObject.newBuilder().setName(resourceName).setDefinition(ByteString.copyFrom((byte[])resource)).build());
        return this;
    }

    @Override
    public DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 addResourceString(String resource, Charset charset, String resourceName) {
        return this.addResourceBytes(resource.getBytes(charset), resourceName);
    }

    @Override
    public DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 addResourceStringUtf8(String resourceString, String resourceName) {
        return this.addResourceString(resourceString, StandardCharsets.UTF_8, resourceName);
    }

    @Override
    public DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 addResourceStream(InputStream resourceStream, String resourceName) {
        ArgumentUtil.ensureNotNull("resource stream", resourceStream);
        try {
            byte[] bytes = StreamUtil.readInputStream(resourceStream);
            return this.addResourceBytes(bytes, resourceName);
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy bpmn resource from stream. %s", e.getMessage());
            throw new ClientException(exceptionMsg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 addResourceFromClasspath(String classpathResource) {
        ArgumentUtil.ensureNotNull("classpath resource", classpathResource);
        try (InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
            if (resourceStream == null) throw new FileNotFoundException(classpathResource);
            DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 deployProcessCommandBuilderStep2 = this.addResourceStream(resourceStream, classpathResource);
            return deployProcessCommandBuilderStep2;
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy resource from classpath. %s", e.getMessage());
            throw new RuntimeException(exceptionMsg, e);
        }
    }

    @Override
    public DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 addResourceFile(String filename) {
        DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 deployProcessCommandBuilderStep2;
        ArgumentUtil.ensureNotNull("filename", filename);
        FileInputStream resourceStream = new FileInputStream(filename);
        try {
            deployProcessCommandBuilderStep2 = this.addResourceStream(resourceStream, filename);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)resourceStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String exceptionMsg = String.format("Cannot deploy resource from file. %s", e.getMessage());
                throw new RuntimeException(exceptionMsg, e);
            }
        }
        ((InputStream)resourceStream).close();
        return deployProcessCommandBuilderStep2;
    }

    @Override
    public DeployProcessCommandStep1.DeployProcessCommandBuilderStep2 addProcessModel(BpmnModelInstance processDefinition, String resourceName) {
        ArgumentUtil.ensureNotNull("process model", processDefinition);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)processDefinition);
        return this.addResourceBytes(outStream.toByteArray(), resourceName);
    }

    @Override
    public FinalCommandStep<DeploymentEvent> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<DeploymentEvent> send() {
        GatewayOuterClass.DeployProcessRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployProcessResponse> future = new RetriableClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployProcessResponse>(DeploymentEventImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.DeployProcessRequest request, StreamObserver streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).deployProcess(request, streamObserver);
    }
}

