/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ReceiveTask;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ReceiveTaskValidator
implements ModelElementValidator<ReceiveTask> {
    public Class<ReceiveTask> getElementType() {
        return ReceiveTask.class;
    }

    public void validate(ReceiveTask element, ValidationResultCollector validationResultCollector) {
        Message message = element.getMessage();
        if (message == null) {
            validationResultCollector.addError(0, "Must reference a message");
            return;
        }
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitionsForBoundaryEvents(element);
        Stream<String> messageNames = ModelUtil.getEventDefinition(eventDefinitions, MessageEventDefinition.class).map(MessageEventDefinition::getMessage).filter(Objects::nonNull).filter(m -> m.getName() != null && !m.getName().isEmpty()).map(Message::getName);
        boolean hasDuplicateMessageName = messageNames.anyMatch(name -> name.equals(message.getName()));
        if (hasDuplicateMessageName) {
            validationResultCollector.addError(0, "Cannot reference the same message name as a boundary event");
        }
    }
}

