/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.builder.AbstractBaseElementBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExecutionListenerBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeExecutionListenersBuilder;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListenerEventType;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListeners;
import java.util.function.Consumer;

public class ZeebeExecutionListenersBuilderImpl<B extends AbstractBaseElementBuilder<?, ?>>
implements ZeebeExecutionListenersBuilder<B> {
    private final B elementBuilder;

    public ZeebeExecutionListenersBuilderImpl(B elementBuilder) {
        this.elementBuilder = elementBuilder;
    }

    @Override
    public B zeebeStartExecutionListener(String type, String retries) {
        ZeebeExecutionListener listener = this.createZeebeExecutionListener();
        listener.setEventType(ZeebeExecutionListenerEventType.start);
        listener.setType(type);
        listener.setRetries(retries);
        return this.elementBuilder;
    }

    @Override
    public B zeebeStartExecutionListener(String type) {
        return (B)this.zeebeStartExecutionListener(type, "3");
    }

    @Override
    public B zeebeEndExecutionListener(String type, String retries) {
        ZeebeExecutionListener listener = this.createZeebeExecutionListener();
        listener.setEventType(ZeebeExecutionListenerEventType.end);
        listener.setType(type);
        listener.setRetries(retries);
        return this.elementBuilder;
    }

    @Override
    public B zeebeEndExecutionListener(String type) {
        return (B)this.zeebeEndExecutionListener(type, "3");
    }

    @Override
    public B zeebeExecutionListener(Consumer<ExecutionListenerBuilder> executionListenerBuilderConsumer) {
        ZeebeExecutionListener listener = this.createZeebeExecutionListener();
        ExecutionListenerBuilder builder = new ExecutionListenerBuilder(listener, (AbstractBaseElementBuilder<?, ?>)this.elementBuilder);
        executionListenerBuilderConsumer.accept(builder);
        return this.elementBuilder;
    }

    private ZeebeExecutionListener createZeebeExecutionListener() {
        ZeebeExecutionListeners executionListeners = ((AbstractBaseElementBuilder)this.elementBuilder).getCreateSingleExtensionElement(ZeebeExecutionListeners.class);
        return ((AbstractBaseElementBuilder)this.elementBuilder).createChild(executionListeners, ZeebeExecutionListener.class);
    }
}

