/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowElementBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExecutionListenerBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeExecutionListenersBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeExecutionListenersBuilderImpl;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.camunda.zeebe.model.bpmn.instance.dc.Bounds;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeInput;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeIoMapping;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeOutput;
import java.util.function.Consumer;

public class AbstractEventSubProcessBuilder<B extends AbstractEventSubProcessBuilder<B>>
extends AbstractFlowElementBuilder<B, SubProcess>
implements ZeebeVariablesMappingBuilder<B>,
ZeebeExecutionListenersBuilder<B> {
    private final ZeebeExecutionListenersBuilder<B> zeebeExecutionListenersBuilder;

    protected AbstractEventSubProcessBuilder(BpmnModelInstance modelInstance, SubProcess element, Class<?> selfType) {
        super(modelInstance, element, selfType);
        this.zeebeExecutionListenersBuilder = new ZeebeExecutionListenersBuilderImpl<AbstractEventSubProcessBuilder>((AbstractEventSubProcessBuilder)this.myself);
    }

    public StartEventBuilder startEvent() {
        return this.startEvent(null);
    }

    public StartEventBuilder startEvent(String id) {
        StartEvent start = this.createChild(StartEvent.class, id);
        BpmnShape startShape = this.createBpmnShape(start);
        BpmnShape subProcessShape = this.findBpmnShape((BaseElement)this.getElement());
        if (subProcessShape != null) {
            Bounds subProcessBounds = subProcessShape.getBounds();
            Bounds startBounds = startShape.getBounds();
            double subProcessX = subProcessBounds.getX();
            double subProcessY = subProcessBounds.getY();
            double subProcessHeight = subProcessBounds.getHeight();
            double startHeight = startBounds.getHeight();
            startBounds.setX(subProcessX + 50.0);
            startBounds.setY(subProcessY + subProcessHeight / 2.0 - startHeight / 2.0);
        }
        return start.builder();
    }

    public StartEventBuilder startEvent(String id, Consumer<StartEventBuilder> consumer) {
        StartEventBuilder builder = this.startEvent(id);
        consumer.accept(builder);
        return builder;
    }

    @Override
    public B zeebeInputExpression(String sourceExpression, String target) {
        String expression = this.asZeebeExpression(sourceExpression);
        return (B)this.zeebeInput(expression, target);
    }

    @Override
    public B zeebeOutputExpression(String sourceExpression, String target) {
        String expression = this.asZeebeExpression(sourceExpression);
        return (B)this.zeebeOutput(expression, target);
    }

    @Override
    public B zeebeInput(String source, String target) {
        ZeebeIoMapping ioMapping = this.getCreateSingleExtensionElement(ZeebeIoMapping.class);
        ZeebeInput input = this.createChild(ioMapping, ZeebeInput.class);
        input.setSource(source);
        input.setTarget(target);
        return (B)((AbstractEventSubProcessBuilder)this.myself);
    }

    @Override
    public B zeebeOutput(String source, String target) {
        ZeebeIoMapping ioMapping = this.getCreateSingleExtensionElement(ZeebeIoMapping.class);
        ZeebeOutput input = this.createChild(ioMapping, ZeebeOutput.class);
        input.setSource(source);
        input.setTarget(target);
        return (B)((AbstractEventSubProcessBuilder)this.myself);
    }

    @Override
    public B zeebeStartExecutionListener(String type, String retries) {
        return (B)((AbstractEventSubProcessBuilder)this.zeebeExecutionListenersBuilder.zeebeStartExecutionListener(type, retries));
    }

    @Override
    public B zeebeStartExecutionListener(String type) {
        return (B)((AbstractEventSubProcessBuilder)this.zeebeExecutionListenersBuilder.zeebeStartExecutionListener(type));
    }

    @Override
    public B zeebeEndExecutionListener(String type, String retries) {
        return (B)((AbstractEventSubProcessBuilder)this.zeebeExecutionListenersBuilder.zeebeEndExecutionListener(type, retries));
    }

    @Override
    public B zeebeEndExecutionListener(String type) {
        return (B)((AbstractEventSubProcessBuilder)this.zeebeExecutionListenersBuilder.zeebeEndExecutionListener(type));
    }

    @Override
    public B zeebeExecutionListener(Consumer<ExecutionListenerBuilder> executionListenerBuilderConsumer) {
        return (B)((AbstractEventSubProcessBuilder)this.zeebeExecutionListenersBuilder.zeebeExecutionListener(executionListenerBuilderConsumer));
    }
}

