/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.CompensateEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.EscalationEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.LinkEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.MessageEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.SignalEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeJobWorkerElementBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeJobWorkerPropertiesBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeJobWorkerPropertiesBuilderImpl;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariableMappingBuilderImpl;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.model.bpmn.builder.zeebe.PublishMessageBuilder;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.LinkEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ThrowEvent;
import java.util.function.Consumer;

public abstract class AbstractThrowEventBuilder<B extends AbstractThrowEventBuilder<B, E>, E extends ThrowEvent>
extends AbstractEventBuilder<B, E>
implements ZeebeJobWorkerElementBuilder<B> {
    private final ZeebeJobWorkerPropertiesBuilder<B> jobWorkerPropertiesBuilder;
    private final ZeebeVariablesMappingBuilder<B> variablesMappingBuilder;

    protected AbstractThrowEventBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
        this.jobWorkerPropertiesBuilder = new ZeebeJobWorkerPropertiesBuilderImpl<AbstractThrowEventBuilder>((AbstractThrowEventBuilder)this.myself);
        this.variablesMappingBuilder = new ZeebeVariableMappingBuilderImpl<AbstractThrowEventBuilder>((AbstractThrowEventBuilder)this.myself);
    }

    public B message(String messageName) {
        MessageEventDefinition messageEventDefinition = this.createMessageEventDefinition(messageName);
        ((ThrowEvent)this.element).getEventDefinitions().add(messageEventDefinition);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public B message(Consumer<PublishMessageBuilder> consumer) {
        MessageEventDefinition messageEventDefinition = this.createEmptyMessageEventDefinition();
        PublishMessageBuilder builder = new PublishMessageBuilder(this.modelInstance, messageEventDefinition, messageEventDefinition::setMessage);
        consumer.accept(builder);
        ((ThrowEvent)this.element).getEventDefinitions().add(messageEventDefinition);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public MessageEventDefinitionBuilder messageEventDefinition() {
        return this.messageEventDefinition(null);
    }

    public MessageEventDefinitionBuilder messageEventDefinition(String id) {
        MessageEventDefinition messageEventDefinition = this.createEmptyMessageEventDefinition();
        if (id != null) {
            messageEventDefinition.setId(id);
        }
        ((ThrowEvent)this.element).getEventDefinitions().add(messageEventDefinition);
        return new MessageEventDefinitionBuilder(this.modelInstance, messageEventDefinition);
    }

    public B signal(String signalName) {
        SignalEventDefinition signalEventDefinition = this.createSignalEventDefinition(signalName);
        ((ThrowEvent)this.element).getEventDefinitions().add(signalEventDefinition);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public SignalEventDefinitionBuilder signalEventDefinition() {
        SignalEventDefinition eventDefinition = this.createEmptySignalEventDefinition();
        ((ThrowEvent)this.element).getEventDefinitions().add(eventDefinition);
        return new SignalEventDefinitionBuilder(this.modelInstance, eventDefinition);
    }

    public SignalEventDefinitionBuilder signalEventDefinition(String signalName) {
        SignalEventDefinition signalEventDefinition = this.createSignalEventDefinition(signalName);
        ((ThrowEvent)this.element).getEventDefinitions().add(signalEventDefinition);
        return new SignalEventDefinitionBuilder(this.modelInstance, signalEventDefinition);
    }

    public B escalationExpression(String escalationCodeExpression) {
        return this.escalation(this.asZeebeExpression(escalationCodeExpression));
    }

    public B escalation(String escalationCode) {
        EscalationEventDefinition escalationEventDefinition = this.createEscalationEventDefinition(escalationCode);
        ((ThrowEvent)this.element).getEventDefinitions().add(escalationEventDefinition);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public EscalationEventDefinitionBuilder escalationEventDefinition(String id) {
        EscalationEventDefinition escalationEventDefinition = this.createEmptyEscalationEventDefinition();
        if (id != null) {
            escalationEventDefinition.setId(id);
        }
        ((ThrowEvent)this.element).getEventDefinitions().add(escalationEventDefinition);
        return new EscalationEventDefinitionBuilder(this.modelInstance, escalationEventDefinition);
    }

    public EscalationEventDefinitionBuilder escalationEventDefinition() {
        EscalationEventDefinition escalationEventDefinition = this.createEmptyEscalationEventDefinition();
        ((ThrowEvent)this.element).getEventDefinitions().add(escalationEventDefinition);
        return new EscalationEventDefinitionBuilder(this.modelInstance, escalationEventDefinition);
    }

    public CompensateEventDefinitionBuilder compensateEventDefinition() {
        return this.compensateEventDefinition(null);
    }

    public CompensateEventDefinitionBuilder compensateEventDefinition(String id) {
        CompensateEventDefinition eventDefinition = this.createInstance(CompensateEventDefinition.class);
        if (id != null) {
            eventDefinition.setId(id);
        }
        ((ThrowEvent)this.element).getEventDefinitions().add(eventDefinition);
        return new CompensateEventDefinitionBuilder(this.modelInstance, eventDefinition);
    }

    public B link(String linkName) {
        this.linkEventDefinition().name(linkName);
        return (B)((AbstractThrowEventBuilder)this.myself);
    }

    public LinkEventDefinitionBuilder linkEventDefinition() {
        return this.linkEventDefinition(null);
    }

    public LinkEventDefinitionBuilder linkEventDefinition(String id) {
        LinkEventDefinition eventDefinition = this.createInstance(LinkEventDefinition.class);
        if (id != null) {
            eventDefinition.setId(id);
        }
        ((ThrowEvent)this.element).getEventDefinitions().add(eventDefinition);
        return new LinkEventDefinitionBuilder(this.modelInstance, eventDefinition);
    }

    @Override
    public B zeebeJobType(String type) {
        return (B)((AbstractThrowEventBuilder)this.jobWorkerPropertiesBuilder.zeebeJobType(type));
    }

    @Override
    public B zeebeJobTypeExpression(String expression) {
        return (B)((AbstractThrowEventBuilder)this.jobWorkerPropertiesBuilder.zeebeJobTypeExpression(expression));
    }

    @Override
    public B zeebeJobRetries(String retries) {
        return (B)((AbstractThrowEventBuilder)this.jobWorkerPropertiesBuilder.zeebeJobRetries(retries));
    }

    @Override
    public B zeebeJobRetriesExpression(String expression) {
        return (B)((AbstractThrowEventBuilder)this.jobWorkerPropertiesBuilder.zeebeJobRetriesExpression(expression));
    }

    @Override
    public B zeebeTaskHeader(String key, String value) {
        return (B)((AbstractThrowEventBuilder)this.jobWorkerPropertiesBuilder.zeebeTaskHeader(key, value));
    }

    @Override
    public B zeebeInputExpression(String sourceExpression, String target) {
        return (B)((AbstractThrowEventBuilder)this.variablesMappingBuilder.zeebeInputExpression(sourceExpression, target));
    }

    @Override
    public B zeebeOutputExpression(String sourceExpression, String target) {
        return (B)((AbstractThrowEventBuilder)this.variablesMappingBuilder.zeebeOutputExpression(sourceExpression, target));
    }

    @Override
    public B zeebeInput(String source, String target) {
        return (B)((AbstractThrowEventBuilder)this.variablesMappingBuilder.zeebeInput(source, target));
    }

    @Override
    public B zeebeOutput(String source, String target) {
        return (B)((AbstractThrowEventBuilder)this.variablesMappingBuilder.zeebeOutput(source, target));
    }
}

