/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.AdHocSubProcess;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class SubProcessValidator
implements ModelElementValidator<SubProcess> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_START_TYPES = Arrays.asList(TimerEventDefinition.class, MessageEventDefinition.class, ErrorEventDefinition.class, SignalEventDefinition.class, EscalationEventDefinition.class, CompensateEventDefinition.class);

    public Class<SubProcess> getElementType() {
        return SubProcess.class;
    }

    public void validate(SubProcess element, ValidationResultCollector validationResultCollector) {
        Collection startEvents = element.getChildElementsByType(StartEvent.class);
        if (startEvents.size() != 1 && !(element instanceof AdHocSubProcess)) {
            validationResultCollector.addError(0, "Must have exactly one start event");
        }
        if (!startEvents.isEmpty()) {
            StartEvent startEvent = (StartEvent)startEvents.iterator().next();
            if (element.triggeredByEvent()) {
                this.validateEventSubprocess(validationResultCollector, startEvent, element);
            } else {
                this.validateEmbeddedSubprocess(validationResultCollector, startEvent);
            }
        }
        ModelUtil.verifyNoDuplicatedEventSubprocesses(element, error -> validationResultCollector.addError(0, error));
        ModelUtil.verifyLinkIntermediateEvents(element, error -> validationResultCollector.addError(0, error));
    }

    private void validateEmbeddedSubprocess(ValidationResultCollector validationResultCollector, StartEvent start) {
        if (!start.getEventDefinitions().isEmpty()) {
            validationResultCollector.addError(0, "Start events in subprocesses must be of type none");
        }
    }

    private void validateEventSubprocess(ValidationResultCollector validationResultCollector, StartEvent start, SubProcess element) {
        Collection<EventDefinition> eventDefinitions = start.getEventDefinitions();
        if (eventDefinitions.isEmpty()) {
            validationResultCollector.addError(0, "Start events in event subprocesses must be one of: message, timer, error, signal, escalation or compensation");
        }
        if (eventDefinitions.stream().anyMatch(CompensateEventDefinition.class::isInstance) && !(element.getParentElement() instanceof SubProcess)) {
            validationResultCollector.addError(0, "A compensation event subprocess is not allowed on the process level");
        }
        eventDefinitions.forEach(def -> {
            if (SUPPORTED_START_TYPES.stream().noneMatch(type -> type.isInstance(def))) {
                validationResultCollector.addError(0, "Start events in event subprocesses must be one of: message, timer, error, signal, escalation or compensation");
            }
        });
        ModelUtil.verifyEventDefinition(start, error -> validationResultCollector.addError(0, error));
    }
}

