/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.ExclusiveGateway;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.InclusiveGateway;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class FlowNodeValidator
implements ModelElementValidator<FlowNode> {
    public Class<FlowNode> getElementType() {
        return FlowNode.class;
    }

    public void validate(FlowNode element, ValidationResultCollector validationResultCollector) {
        if (element instanceof ExclusiveGateway || element instanceof InclusiveGateway) {
            return;
        }
        boolean hasAnyConditionalFlow = element.getOutgoing().stream().anyMatch(s -> s.getConditionExpression() != null);
        if (hasAnyConditionalFlow) {
            validationResultCollector.addError(0, "Conditional sequence flows are only supported at exclusive or inclusive gateway");
        }
    }
}

