/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.node.Node;
import java.util.List;

public class IndexNode<T>
extends Node<T> {
    private final int index;

    public IndexNode(Adapter<T> runtime, int index) {
        super(runtime);
        this.index = index;
    }

    @Override
    public T search(T input) {
        if (this.runtime.typeOf(input) == JmesPathType.ARRAY) {
            List<T> elements = this.runtime.toList(input);
            int i = this.index;
            if (i < 0) {
                i = elements.size() + i;
            }
            if (i >= 0 && i < elements.size()) {
                return elements.get(i);
            }
        }
        return this.runtime.createNull();
    }

    @Override
    protected String internalToString() {
        return String.valueOf(this.index);
    }

    @Override
    protected boolean internalEquals(Object o) {
        IndexNode other = (IndexNode)o;
        return this.index == other.index;
    }

    @Override
    protected int internalHashCode() {
        return this.index;
    }
}

