/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback.policy;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.policy.FileNamePatternValidator;
import io.bootique.logback.policy.RollingPolicyFactory;

@JsonTypeName(value="time")
@BQConfig
public class TimeBasedPolicyFactory
extends RollingPolicyFactory {
    private String totalSize;

    @BQConfigProperty
    public void setTotalSize(String totalSize) {
        this.totalSize = totalSize;
    }

    protected TimeBasedRollingPolicy<ILoggingEvent> instantiatePolicy(LoggerContext context) {
        TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
        this.setupBasePolicySettings((TimeBasedRollingPolicy<ILoggingEvent>)policy);
        policy.setContext((Context)context);
        return policy;
    }

    @Override
    public TriggeringPolicy<ILoggingEvent> createTriggeringPolicy(LoggerContext context) {
        return null;
    }

    @Override
    protected FileNamePatternValidator getFileNamePatternValidator(LoggerContext context) {
        return new FileNamePatternValidator(context, this.getFileNamePattern(), TimeBasedRollingPolicy.class.getSimpleName()){

            @Override
            protected void validate() {
                this.checkPattern(true, false);
            }
        };
    }

    protected void setupBasePolicySettings(TimeBasedRollingPolicy<ILoggingEvent> policy) {
        policy.setFileNamePattern(this.getFileNamePattern());
        if (this.getHistorySize() > 0) {
            policy.setMaxHistory(this.getHistorySize());
            policy.setCleanHistoryOnStart(true);
        }
        if (this.totalSize != null && this.totalSize.length() > 0) {
            policy.setTotalSizeCap(FileSize.valueOf((String)this.totalSize));
        }
    }
}

