/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback.appender;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.PolymorphicConfiguration;
import io.bootique.logback.appender.ConsoleAppenderFactory;

@BQConfig(value="Appender of a given type.")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ConsoleAppenderFactory.class)
public abstract class AppenderFactory
implements PolymorphicConfiguration {
    private String logFormat;
    private String name;

    public String getLogFormat() {
        return this.logFormat;
    }

    @BQConfigProperty(value="Log format specification compatible with Logback framework. If not set, the value is propagated from the parent configuration.")
    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public abstract Appender<ILoggingEvent> createAppender(LoggerContext var1, String var2);

    public String getName() {
        return this.name;
    }

    @BQConfigProperty(value="Appender name.")
    public void setName(String name) {
        this.name = name;
    }

    protected PatternLayout createLayout(LoggerContext context, String defaultLogFormat) {
        String logFormat = this.logFormat != null ? this.logFormat : defaultLogFormat;
        PatternLayout layout = new PatternLayout();
        layout.setPattern(logFormat);
        layout.setContext((Context)context);
        layout.start();
        return layout;
    }

    protected Appender<ILoggingEvent> asAsync(Appender<ILoggingEvent> appender) {
        return this.asAsync(appender, appender.getContext());
    }

    protected Appender<ILoggingEvent> asAsync(Appender<ILoggingEvent> appender, Context context) {
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setIncludeCallerData(false);
        asyncAppender.setQueueSize(256);
        asyncAppender.setDiscardingThreshold(-1);
        asyncAppender.setContext(context);
        asyncAppender.setName(appender.getName());
        asyncAppender.addAppender(appender);
        asyncAppender.start();
        return asyncAppender;
    }
}

