/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.LogbackLevel;
import io.bootique.logback.LoggerFactory;
import io.bootique.logback.appender.AppenderFactory;
import io.bootique.logback.appender.ConsoleAppenderFactory;
import io.bootique.shutdown.ShutdownManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.ILoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@BQConfig
public class LogbackContextFactory {
    private LoggerFactory rootLoggerFactory = new LoggerFactory();
    private String logFormat;
    private Map<String, LoggerFactory> loggers = Collections.emptyMap();
    private Collection<AppenderFactory> appenders = Collections.emptyList();
    private boolean useLogbackConfig = false;
    private boolean debugLogback;

    public Logger createRootLogger(ShutdownManager shutdownManager, Map<String, Level> defaultLevels) {
        LoggerContext context = this.createLogbackContext();
        shutdownManager.addShutdownHook(() -> ((LoggerContext)context).stop());
        this.rerouteJUL();
        if (!this.useLogbackConfig) {
            Map<String, LoggerFactory> loggers = this.mergeLevels(defaultLevels);
            this.configLogbackContext(context, loggers);
        }
        return context.getLogger("ROOT");
    }

    protected void configLogbackContext(LoggerContext context, Map<String, LoggerFactory> loggers) {
        context.reset();
        if (this.debugLogback) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)context, (OnConsoleStatusListener)new OnConsoleStatusListener());
        }
        LevelChangePropagator propagator = new LevelChangePropagator();
        propagator.setContext((Context)context);
        propagator.setResetJUL(true);
        context.addListener((LoggerContextListener)propagator);
        if (this.appenders.isEmpty()) {
            this.setAppenders(Collections.singletonList(new ConsoleAppenderFactory()));
        }
        Map<String, Appender<ILoggingEvent>> namedAppenders = this.createNamedAppenders(context);
        Collection<Appender<ILoggingEvent>> anonAppenders = this.createAnonymousAppenders(context);
        loggers.forEach((name, lf) -> lf.configLogger(context.getLogger(name), namedAppenders, Collections.emptyList()));
        this.rootLoggerFactory.configLogger(context.getLogger("ROOT"), namedAppenders, anonAppenders);
    }

    private Map<String, Appender<ILoggingEvent>> createNamedAppenders(LoggerContext context) {
        HashSet<String> uniqueAppenderRefs = new HashSet<String>(this.getAppenderRefs());
        this.loggers.values().forEach(f -> uniqueAppenderRefs.addAll(f.getAppenderRefs()));
        HashMap<String, Appender<ILoggingEvent>> namedAppenders = new HashMap<String, Appender<ILoggingEvent>>();
        this.appenders.forEach(a -> {
            if (a.getName() != null && uniqueAppenderRefs.contains(a.getName())) {
                namedAppenders.put(a.getName(), a.createAppender(context, this.getLogFormat()));
            }
        });
        return namedAppenders;
    }

    private Collection<Appender<ILoggingEvent>> createAnonymousAppenders(LoggerContext context) {
        ArrayList<Appender<ILoggingEvent>> namedAppenders = new ArrayList<Appender<ILoggingEvent>>();
        this.appenders.forEach(a -> {
            if (a.getName() == null) {
                namedAppenders.add(a.createAppender(context, this.getLogFormat()));
            }
        });
        return namedAppenders;
    }

    private String getLogFormat() {
        return this.logFormat != null ? this.logFormat : "%-5p [%d{ISO8601,UTC}] %thread %c{20}: %m%n%rEx";
    }

    @BQConfigProperty(value="Log format specification used by child appenders unless redefined at the appender level, or not relevant for a given type of appender. The spec is compatible with Logback framework. The default is '%-5p [%d{ISO8601,UTC}] %thread %c{20}: %m%n%rEx'")
    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    protected Map<String, LoggerFactory> mergeLevels(Map<String, Level> levels) {
        if (levels.isEmpty()) {
            return this.loggers;
        }
        HashMap<String, LoggerFactory> merged = new HashMap<String, LoggerFactory>(this.loggers);
        levels.forEach((name, level) -> {
            LoggerFactory factory = this.loggers.get(name);
            if (factory == null) {
                factory = new LoggerFactory();
                factory.setLevel(this.mapJULLevel((Level)level));
                merged.put((String)name, factory);
            }
        });
        return merged;
    }

    protected LogbackLevel mapJULLevel(Level level) {
        return JulLevel.valueOf(level.getName()).getLevel();
    }

    protected LoggerContext createLogbackContext() {
        long startTime = System.nanoTime();
        ILoggerFactory iLoggerFactory;
        while (!((iLoggerFactory = org.slf4j.LoggerFactory.getILoggerFactory()) instanceof LoggerContext)) {
            if (System.nanoTime() - startTime > 10000000L) {
                throw new IllegalStateException("Unable to acquire the logger context");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return (LoggerContext)iLoggerFactory;
    }

    void rerouteJUL() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public LogbackLevel getLevel() {
        return this.rootLoggerFactory.getLevel();
    }

    @BQConfigProperty(value="Root log level. Can be overridden by individual loggers. The default is 'info'.")
    public void setLevel(LogbackLevel level) {
        this.rootLoggerFactory.setLevel(level);
    }

    public Map<String, LoggerFactory> getLoggers() {
        return this.loggers;
    }

    @BQConfigProperty(value="Per-package or per-class loggers. Keys in the map are logger names.")
    public void setLoggers(Map<String, LoggerFactory> loggers) {
        this.loggers = loggers;
    }

    public Collection<AppenderFactory> getAppenders() {
        return this.appenders;
    }

    @BQConfigProperty(value="One or more appenders that will render the logs to console, file, etc. If the list is empty, console appender is used with default settings.")
    public void setAppenders(Collection<AppenderFactory> appenders) {
        this.appenders = appenders;
    }

    @BQConfigProperty(value="If true, all Bootique logback settings are ignored and the user is expected to provide its own config file per Logback documentation. This is only needed for a few advanced options not directly available via Bootique config. So the value should stay false (which is the default).")
    public void setUseLogbackConfig(boolean useLogbackConfig) {
        this.useLogbackConfig = useLogbackConfig;
    }

    @BQConfigProperty(value="If true, Logback configuration debugging information will be printed to console. Helps to deal with Logback configuration issues.")
    public void setDebugLogback(boolean debugLogback) {
        this.debugLogback = debugLogback;
    }

    public Collection<String> getAppenderRefs() {
        return this.rootLoggerFactory.getAppenderRefs();
    }

    @BQConfigProperty(value="Collection of appender names which should be added to root Logger.")
    public void setAppenderRefs(Collection<String> appenderRefs) {
        this.rootLoggerFactory.setAppenderRefs(appenderRefs);
    }

    private static enum JulLevel {
        ALL(LogbackLevel.all),
        CONFIG(LogbackLevel.debug),
        FINE(LogbackLevel.debug),
        FINER(LogbackLevel.debug),
        FINEST(LogbackLevel.trace),
        INFO(LogbackLevel.info),
        OFF(LogbackLevel.off),
        SEVERE(LogbackLevel.error),
        WARNING(LogbackLevel.warn);

        private LogbackLevel level;

        private JulLevel(LogbackLevel level) {
            this.level = level;
        }

        public LogbackLevel getLevel() {
            return this.level;
        }
    }
}

